"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/he/_lib/formatDistance/index", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = formatDistance;
    var formatDistanceLocale = {
      lessThanXSeconds: {
        one: 'פחות משנייה',
        two: 'פחות משתי שניות',
        other: 'פחות מ־{{count}} שניות'
      },
      xSeconds: {
        one: 'שנייה',
        two: 'שתי שניות',
        other: '{{count}} שניות'
      },
      halfAMinute: 'חצי דקה',
      lessThanXMinutes: {
        one: 'פחות מדקה',
        two: 'פחות משתי דקות',
        other: 'פחות מ־{{count}} דקות'
      },
      xMinutes: {
        one: 'דקה',
        two: 'שתי דקות',
        other: '{{count}} דקות'
      },
      aboutXHours: {
        one: 'בערך שעה',
        two: 'בערך שעתיים',
        other: 'בערך {{count}} שעות'
      },
      xHours: {
        one: 'שעה',
        two: 'שעתיים',
        other: '{{count}} שעות'
      },
      xDays: {
        one: 'יום',
        two: 'יומיים',
        other: '{{count}} ימים'
      },
      aboutXWeeks: {
        one: 'בערך שבוע',
        two: 'בערך שבועיים',
        other: 'בערך {{count}} שבועות'
      },
      xWeeks: {
        one: 'שבוע',
        two: 'שבועיים',
        other: '{{count}} שבועות'
      },
      aboutXMonths: {
        one: 'בערך חודש',
        two: 'בערך חודשיים',
        other: 'בערך {{count}} חודשים'
      },
      xMonths: {
        one: 'חודש',
        two: 'חודשיים',
        other: '{{count}} חודשים'
      },
      aboutXYears: {
        one: 'בערך שנה',
        two: 'בערך שנתיים',
        other: 'בערך {{count}} שנים'
      },
      xYears: {
        one: 'שנה',
        two: 'שנתיים',
        other: '{{count}} שנים'
      },
      overXYears: {
        one: 'יותר משנה',
        two: 'יותר משנתיים',
        other: 'יותר מ־{{count}} שנים'
      },
      almostXYears: {
        one: 'כמעט שנה',
        two: 'כמעט שנתיים',
        other: 'כמעט {{count}} שנים'
      }
    };

    function formatDistance(token, count, options) {
      options = options || {}; // Return word instead of `in one day` or `one day ago`

      if (token === 'xDays' && options.addSuffix && count <= 2) {
        return options.comparison > 0 ? {
          1: 'מחר',
          2: 'מחרתיים'
        }[count] : {
          1: 'אתמול',
          2: 'שלשום'
        }[count];
      }

      var result;

      if (typeof formatDistanceLocale[token] === 'string') {
        result = formatDistanceLocale[token];
      } else if (count === 1) {
        result = formatDistanceLocale[token].one;
      } else if (count === 2) {
        result = formatDistanceLocale[token].two;
      } else {
        result = formatDistanceLocale[token].other.replace('{{count}}', count);
      }

      if (options.addSuffix) {
        if (options.comparison > 0) {
          return 'בעוד ' + result;
        } else {
          return 'לפני ' + result;
        }
      }

      return result;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map