"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/hu/_lib/match/index", ['module', 'exports', 'require', '../../../_lib/buildMatchPatternFn/index', '../../../_lib/buildMatchFn/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _index = _interopRequireDefault(require("../../../_lib/buildMatchPatternFn/index"));

    var _index2 = _interopRequireDefault(require("../../../_lib/buildMatchFn/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    var matchOrdinalNumberPattern = /^(\d+)\.?/i;
    var parseOrdinalNumberPattern = /\d+/i;
    var matchEraPatterns = {
      narrow: /^(ie\.|isz\.)/i,
      abbreviated: /^(i\.\s?e\.?|b?\s?c\s?e|i\.\s?sz\.?)/i,
      wide: /^(Krisztus előtt|időszámításunk előtt|időszámításunk szerint|i\. sz\.)/i
    };
    var parseEraPatterns = {
      narrow: [/ie/i, /isz/i],
      abbreviated: [/^(i\.?\s?e\.?|b\s?ce)/i, /^(i\.?\s?sz\.?|c\s?e)/i],
      any: [/előtt/i, /(szerint|i. sz.)/i]
    };
    var matchQuarterPatterns = {
      narrow: /^[1234]\.?/i,
      abbreviated: /^[1234]?\.?\s?n\.év/i,
      wide: /^([1234]|I|II|III|IV)?\.?\s?negyedév/i
    };
    var parseQuarterPatterns = {
      any: [/1|I$/i, /2|II$/i, /3|III/i, /4|IV/i]
    };
    var matchMonthPatterns = {
      narrow: /^[jfmaásond]|sz/i,
      abbreviated: /^(jan\.?|febr\.?|márc\.?|ápr\.?|máj\.?|jún\.?|júl\.?|aug\.?|szept\.?|okt\.?|nov\.?|dec\.?)/i,
      wide: /^(január|február|március|április|május|június|július|augusztus|szeptember|október|november|december)/i
    };
    var parseMonthPatterns = {
      narrow: [/^j/i, /^f/i, /^m/i, /^a|á/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s|sz/i, /^o/i, /^n/i, /^d/i],
      any: [/^ja/i, /^f/i, /^már/i, /^áp/i, /^máj/i, /^jún/i, /^júl/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
    };
    var matchDayPatterns = {
      narrow: /^([vhkpc]|sz|cs|sz)/i,
      short: /^([vhkp]|sze|cs|szo)/i,
      abbreviated: /^([vhkp]|sze|cs|szo)/i,
      wide: /^(vasárnap|hétfő|kedd|szerda|csütörtök|péntek|szombat)/i
    };
    var parseDayPatterns = {
      narrow: [/^v/i, /^h/i, /^k/i, /^sz/i, /^c/i, /^p/i, /^sz/i],
      any: [/^v/i, /^h/i, /^k/i, /^sze/i, /^c/i, /^p/i, /^szo/i]
    };
    var matchDayPeriodPatterns = {
      any: /^((de|du)\.?|éjfél|délután|dél|reggel|este|éjjel)/i
    };
    var parseDayPeriodPatterns = {
      any: {
        am: /^de\.?/i,
        pm: /^du\.?/i,
        midnight: /^éjf/i,
        noon: /^dé/i,
        morning: /reg/i,
        afternoon: /^délu\.?/i,
        evening: /es/i,
        night: /éjj/i
      }
    };
    var match = {
      ordinalNumber: (0, _index.default)({
        matchPattern: matchOrdinalNumberPattern,
        parsePattern: parseOrdinalNumberPattern,
        valueCallback: function (value) {
          return parseInt(value, 10);
        }
      }),
      era: (0, _index2.default)({
        matchPatterns: matchEraPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseEraPatterns,
        defaultParseWidth: 'any'
      }),
      quarter: (0, _index2.default)({
        matchPatterns: matchQuarterPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseQuarterPatterns,
        defaultParseWidth: 'any',
        valueCallback: function (index) {
          return index + 1;
        }
      }),
      month: (0, _index2.default)({
        matchPatterns: matchMonthPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseMonthPatterns,
        defaultParseWidth: 'any'
      }),
      day: (0, _index2.default)({
        matchPatterns: matchDayPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseDayPatterns,
        defaultParseWidth: 'any'
      }),
      dayPeriod: (0, _index2.default)({
        matchPatterns: matchDayPeriodPatterns,
        defaultMatchWidth: 'any',
        parsePatterns: parseDayPeriodPatterns,
        defaultParseWidth: 'any'
      })
    };
    var _default = match;
    exports.default = _default;
    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map