"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/is/_lib/formatDistance/index", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = formatDistance;
    var formatDistanceLocale = {
      lessThanXSeconds: {
        one: 'minna en 1 sekúnda',
        other: 'minna en {{count}} sekúndur'
      },
      xSeconds: {
        one: '1 sekúnda',
        other: '{{count}} sekúndur'
      },
      halfAMinute: 'hálf mínúta',
      lessThanXMinutes: {
        one: 'minna en 1 mínúta',
        other: 'minna en {{count}} mínútur'
      },
      xMinutes: {
        one: '1 mínúta',
        other: '{{count}} mínútur'
      },
      aboutXHours: {
        one: 'u.þ.b. 1 klukkustund',
        other: 'u.þ.b. {{count}} klukkustundir'
      },
      xHours: {
        one: '1 klukkustund',
        other: '{{count}} klukkustundir'
      },
      xDays: {
        one: '1 dagur',
        other: '{{count}} dagar'
      },
      aboutXWeeks: {
        one: 'um viku',
        other: 'um {{count}} vikur'
      },
      xWeeks: {
        one: '1 viku',
        other: '{{count}} vikur'
      },
      aboutXMonths: {
        one: 'u.þ.b. 1 mánuður',
        other: 'u.þ.b. {{count}} mánuðir'
      },
      xMonths: {
        one: '1 mánuður',
        other: '{{count}} mánuðir'
      },
      aboutXYears: {
        one: 'u.þ.b. 1 ár',
        other: 'u.þ.b. {{count}} ár'
      },
      xYears: {
        one: '1 ár',
        other: '{{count}} ár'
      },
      overXYears: {
        one: 'meira en 1 ár',
        other: 'meira en {{count}} ár'
      },
      almostXYears: {
        one: 'næstum 1 ár',
        other: 'næstum {{count}} ár'
      }
    };

    function formatDistance(token, count, options) {
      options = options || {};
      var result;

      if (typeof formatDistanceLocale[token] === 'string') {
        result = formatDistanceLocale[token];
      } else if (count === 1) {
        result = formatDistanceLocale[token].one;
      } else {
        result = formatDistanceLocale[token].other.replace('{{count}}', count);
      }

      if (options.addSuffix) {
        if (options.comparison > 0) {
          return 'í ' + result;
        } else {
          return result + ' síðan';
        }
      }

      return result;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map