"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/it/_lib/formatRelative/index", ['module', 'exports', 'require', '../../../../_lib/isSameUTCWeek/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = formatRelative;

    var _index = _interopRequireDefault(require("../../../../_lib/isSameUTCWeek/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    var weekdays = ['domenica', 'lunedì', 'martedì', 'mercoledì', 'giovedì', 'venerdì', 'sabato'];

    function lastWeek(day) {
      switch (day) {
        case 0:
          return "'domenica scorsa alle' p";

        default:
          return "'" + weekdays[day] + " scorso alle' p";
      }
    }

    function thisWeek(day) {
      return "'" + weekdays[day] + " alle' p";
    }

    function nextWeek(day) {
      switch (day) {
        case 0:
          return "'domenica prossima alle' p";

        default:
          return "'" + weekdays[day] + " prossimo alle' p";
      }
    }

    var formatRelativeLocale = {
      lastWeek: function (date, baseDate, options) {
        var day = date.getUTCDay();

        if ((0, _index.default)(date, baseDate, options)) {
          return thisWeek(day);
        } else {
          return lastWeek(day);
        }
      },
      yesterday: "'ieri alle' p",
      today: "'oggi alle' p",
      tomorrow: "'domani alle' p",
      nextWeek: function (date, baseDate, options) {
        var day = date.getUTCDay();

        if ((0, _index.default)(date, baseDate, options)) {
          return thisWeek(day);
        } else {
          return nextWeek(day);
        }
      },
      other: 'P'
    };

    function formatRelative(token, date, baseDate, options) {
      var format = formatRelativeLocale[token];

      if (typeof format === 'function') {
        return format(date, baseDate, options);
      }

      return format;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map