"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/ja/_lib/localize/index", ['module', 'exports', 'require', '../../../_lib/buildLocalizeFn/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _index = _interopRequireDefault(require("../../../_lib/buildLocalizeFn/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    var eraValues = {
      narrow: ['BC', 'AC'],
      abbreviated: ['紀元前', '西暦'],
      wide: ['紀元前', '西暦']
    };
    var quarterValues = {
      narrow: ['1', '2', '3', '4'],
      abbreviated: ['Q1', 'Q2', 'Q3', 'Q4'],
      wide: ['第1四半期', '第2四半期', '第3四半期', '第4四半期']
    };
    var monthValues = {
      narrow: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
      abbreviated: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
      wide: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月']
    };
    var dayValues = {
      narrow: ['日', '月', '火', '水', '木', '金', '土'],
      short: ['日', '月', '火', '水', '木', '金', '土'],
      abbreviated: ['日', '月', '火', '水', '木', '金', '土'],
      wide: ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日']
    };
    var dayPeriodValues = {
      narrow: {
        am: '午前',
        pm: '午後',
        midnight: '深夜',
        noon: '正午',
        morning: '朝',
        afternoon: '午後',
        evening: '夜',
        night: '深夜'
      },
      abbreviated: {
        am: '午前',
        pm: '午後',
        midnight: '深夜',
        noon: '正午',
        morning: '朝',
        afternoon: '午後',
        evening: '夜',
        night: '深夜'
      },
      wide: {
        am: '午前',
        pm: '午後',
        midnight: '深夜',
        noon: '正午',
        morning: '朝',
        afternoon: '午後',
        evening: '夜',
        night: '深夜'
      }
    };
    var formattingDayPeriodValues = {
      narrow: {
        am: '午前',
        pm: '午後',
        midnight: '深夜',
        noon: '正午',
        morning: '朝',
        afternoon: '午後',
        evening: '夜',
        night: '深夜'
      },
      abbreviated: {
        am: '午前',
        pm: '午後',
        midnight: '深夜',
        noon: '正午',
        morning: '朝',
        afternoon: '午後',
        evening: '夜',
        night: '深夜'
      },
      wide: {
        am: '午前',
        pm: '午後',
        midnight: '深夜',
        noon: '正午',
        morning: '朝',
        afternoon: '午後',
        evening: '夜',
        night: '深夜'
      }
    };

    function ordinalNumber(dirtyNumber, dirtyOptions) {
      var number = Number(dirtyNumber); // If ordinal numbers depend on context, for example,
      // if they are different for different grammatical genders,
      // use `options.unit`:
      //
      //   var options = dirtyOptions || {}
      //   var unit = String(options.unit)
      //
      // where `unit` can be 'year', 'quarter', 'month', 'week', 'date', 'dayOfYear',
      // 'day', 'hour', 'minute', 'second'

      var unit = String((dirtyOptions || {}).unit);

      if (unit === 'date') {
        return number + '日';
      }

      return number;
    }

    var localize = {
      ordinalNumber: ordinalNumber,
      era: (0, _index.default)({
        values: eraValues,
        defaultWidth: 'wide'
      }),
      quarter: (0, _index.default)({
        values: quarterValues,
        defaultWidth: 'wide',
        argumentCallback: function (quarter) {
          return Number(quarter) - 1;
        }
      }),
      month: (0, _index.default)({
        values: monthValues,
        defaultWidth: 'wide'
      }),
      day: (0, _index.default)({
        values: dayValues,
        defaultWidth: 'wide'
      }),
      dayPeriod: (0, _index.default)({
        values: dayPeriodValues,
        defaultWidth: 'wide',
        formattingValues: formattingDayPeriodValues,
        defaultFormattingWidth: 'wide'
      })
    };
    var _default = localize;
    exports.default = _default;
    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map