"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/pt/_lib/match/index", ['module', 'exports', 'require', '../../../_lib/buildMatchPatternFn/index', '../../../_lib/buildMatchFn/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _index = _interopRequireDefault(require("../../../_lib/buildMatchPatternFn/index"));

    var _index2 = _interopRequireDefault(require("../../../_lib/buildMatchFn/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    var matchOrdinalNumberPattern = /^(\d+)(º|ª)?/i;
    var parseOrdinalNumberPattern = /\d+/i;
    var matchEraPatterns = {
      narrow: /^(ac|dc|a|d)/i,
      abbreviated: /^(a\.?\s?c\.?|a\.?\s?e\.?\s?c\.?|d\.?\s?c\.?|e\.?\s?c\.?)/i,
      wide: /^(antes de cristo|antes da era comum|depois de cristo|era comum)/i
    };
    var parseEraPatterns = {
      any: [/^ac/i, /^dc/i],
      wide: [/^(antes de cristo|antes da era comum)/i, /^(depois de cristo|era comum)/i]
    };
    var matchQuarterPatterns = {
      narrow: /^[1234]/i,
      abbreviated: /^T[1234]/i,
      wide: /^[1234](º|ª)? trimestre/i
    };
    var parseQuarterPatterns = {
      any: [/1/i, /2/i, /3/i, /4/i]
    };
    var matchMonthPatterns = {
      narrow: /^[jfmasond]/i,
      abbreviated: /^(jan|fev|mar|abr|mai|jun|jul|ago|set|out|nov|dez)/i,
      wide: /^(janeiro|fevereiro|março|abril|maio|junho|julho|agosto|setembro|outubro|novembro|dezembro)/i
    };
    var parseMonthPatterns = {
      narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
      any: [/^ja/i, /^f/i, /^mar/i, /^ab/i, /^mai/i, /^jun/i, /^jul/i, /^ag/i, /^s/i, /^o/i, /^n/i, /^d/i]
    };
    var matchDayPatterns = {
      narrow: /^[dstq]/i,
      short: /^(dom|seg|ter|qua|qui|sex|s[áa]b)/i,
      abbreviated: /^(dom|seg|ter|qua|qui|sex|s[áa]b)/i,
      wide: /^(domingo|segunda-?\s?feira|terça-?\s?feira|quarta-?\s?feira|quinta-?\s?feira|sexta-?\s?feira|s[áa]bado)/i
    };
    var parseDayPatterns = {
      narrow: [/^d/i, /^s/i, /^t/i, /^q/i, /^q/i, /^s/i, /^s/i],
      any: [/^d/i, /^seg/i, /^t/i, /^qua/i, /^qui/i, /^sex/i, /^s[áa]/i]
    };
    var matchDayPeriodPatterns = {
      narrow: /^(a|p|meia-?\s?noite|meio-?\s?dia|(da) (manh[ãa]|tarde|noite|madrugada))/i,
      any: /^([ap]\.?\s?m\.?|meia-?\s?noite|meio-?\s?dia|(da) (manh[ãa]|tarde|noite|madrugada))/i
    };
    var parseDayPeriodPatterns = {
      any: {
        am: /^a/i,
        pm: /^p/i,
        midnight: /^meia/i,
        noon: /^meio/i,
        morning: /manh[ãa]/i,
        afternoon: /tarde/i,
        evening: /noite/i,
        night: /madrugada/i
      }
    };
    var match = {
      ordinalNumber: (0, _index.default)({
        matchPattern: matchOrdinalNumberPattern,
        parsePattern: parseOrdinalNumberPattern,
        valueCallback: function (value) {
          return parseInt(value, 10);
        }
      }),
      era: (0, _index2.default)({
        matchPatterns: matchEraPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseEraPatterns,
        defaultParseWidth: 'any'
      }),
      quarter: (0, _index2.default)({
        matchPatterns: matchQuarterPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseQuarterPatterns,
        defaultParseWidth: 'any',
        valueCallback: function (index) {
          return index + 1;
        }
      }),
      month: (0, _index2.default)({
        matchPatterns: matchMonthPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseMonthPatterns,
        defaultParseWidth: 'any'
      }),
      day: (0, _index2.default)({
        matchPatterns: matchDayPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseDayPatterns,
        defaultParseWidth: 'any'
      }),
      dayPeriod: (0, _index2.default)({
        matchPatterns: matchDayPeriodPatterns,
        defaultMatchWidth: 'any',
        parsePatterns: parseDayPeriodPatterns,
        defaultParseWidth: 'any'
      })
    };
    var _default = match;
    exports.default = _default;
    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map