"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/sl/_lib/formatDistance/index", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = formatDistance;
    var distanceInWordsLocale = {
      lessThanXSeconds: {
        one: 'manj kot {{count}} sekunda',
        two: 'manj kot {{count}} sekundi',
        few: 'manj kot {{count}} sekunde',
        other: 'manj kot {{count}} sekund'
      },
      xSeconds: {
        one: '{{count}} sekunda',
        two: '{{count}} sekundi',
        few: '{{count}} sekunde',
        other: '{{count}} sekund'
      },
      halfAMinute: 'pol minute',
      lessThanXMinutes: {
        one: 'manj kot {{count}} minuta',
        two: 'manj kot {{count}} minuti',
        few: 'manj kot {{count}} minute',
        other: 'manj kot {{count}} minut'
      },
      xMinutes: {
        one: '{{count}} minuta',
        two: '{{count}} minuti',
        few: '{{count}} minute',
        other: '{{count}} minut'
      },
      aboutXHours: {
        one: 'približno {{count}} ura',
        two: 'približno {{count}} uri',
        few: 'približno {{count}} ure',
        other: 'približno {{count}} ur'
      },
      xHours: {
        one: '{{count}} ura',
        two: '{{count}} uri',
        few: '{{count}} ure',
        other: '{{count}} ur'
      },
      xDays: {
        one: '{{count}} dan',
        two: '{{count}} dni',
        few: '{{count}} dni',
        other: '{{count}} dni'
      },
      aboutXWeeks: {
        one: 'približno {{count}} teden',
        two: 'približno {{count}} tedna',
        few: 'približno {{count}} tedne',
        other: 'približno {{count}} tednov'
      },
      xWeeks: {
        one: '{{count}} teden',
        two: '{{count}} tedna',
        few: '{{count}} tedne',
        other: '{{count}} tednov'
      },
      aboutXMonths: {
        one: 'približno {{count}} mesec',
        two: 'približno {{count}} meseca',
        few: 'približno {{count}} mesece',
        other: 'približno {{count}} mesecev'
      },
      xMonths: {
        one: '{{count}} mesec',
        two: '{{count}} meseca',
        few: '{{count}} meseci',
        other: '{{count}} mesecev'
      },
      aboutXYears: {
        one: 'približno {{count}} leto',
        two: 'približno {{count}} leti',
        few: 'približno {{count}} leta',
        other: 'približno {{count}} let'
      },
      xYears: {
        one: '{{count}} leto',
        two: '{{count}} leti',
        few: '{{count}} leta',
        other: '{{count}} let'
      },
      overXYears: {
        one: 'več kot {{count}} leto',
        two: 'več kot {{count}} leti',
        few: 'več kot {{count}} leta',
        other: 'več kot {{count}} let'
      },
      almostXYears: {
        one: 'skoraj {{count}} leto',
        two: 'skoraj {{count}} leti',
        few: 'skoraj {{count}} leta',
        other: 'skoraj {{count}} let'
      }
    };
    var distanceInWordsLocalePast = {
      lessThanXSeconds: {
        one: 'manj kot {{count}} sekundo',
        two: 'manj kot {{count}} sekundama',
        few: 'manj kot {{count}} sekundami',
        other: 'manj kot {{count}} sekundami'
      },
      xSeconds: {
        one: '{{count}} sekundo',
        two: '{{count}} sekundama',
        few: '{{count}} sekundami',
        other: '{{count}} sekundami'
      },
      halfAMinute: 'pol minute',
      lessThanXMinutes: {
        one: 'manj kot {{count}} minuto',
        two: 'manj kot {{count}} minutama',
        few: 'manj kot {{count}} minutami',
        other: 'manj kot {{count}} minutami'
      },
      xMinutes: {
        one: '{{count}} minuto',
        two: '{{count}} minutama',
        few: '{{count}} minutami',
        other: '{{count}} minutami'
      },
      aboutXHours: {
        one: 'približno {{count}} uro',
        two: 'približno {{count}} urama',
        few: 'približno {{count}} urami',
        other: 'približno {{count}} urami'
      },
      xHours: {
        one: '{{count}} uro',
        two: '{{count}} urama',
        few: '{{count}} urami',
        other: '{{count}} urami'
      },
      xDays: {
        one: '{{count}} dnem',
        two: '{{count}} dnevoma',
        few: '{{count}} dnevi',
        other: '{{count}} dnevi'
      },
      aboutXMonths: {
        one: 'približno {{count}} mesecem',
        two: 'približno {{count}} mesecema',
        few: 'približno {{count}} meseci',
        other: 'približno {{count}} meseci'
      },
      xMonths: {
        one: '{{count}} mesecem',
        two: '{{count}} mesecema',
        few: '{{count}} meseci',
        other: '{{count}} meseci'
      },
      aboutXYears: {
        one: 'približno {{count}} letom',
        two: 'približno {{count}} letoma',
        few: 'približno {{count}} leti',
        other: 'približno {{count}} leti'
      },
      xYears: {
        one: '{{count}} letom',
        two: '{{count}} letoma',
        few: '{{count}} leti',
        other: '{{count}} leti'
      },
      overXYears: {
        one: 'več kot {{count}} letom',
        two: 'več kot {{count}} letoma',
        few: 'več kot {{count}} leti',
        other: 'več kot {{count}} leti'
      },
      almostXYears: {
        one: 'skoraj {{count}} letom',
        two: 'skoraj {{count}} letoma',
        few: 'skoraj {{count}} leti',
        other: 'skoraj {{count}} leti'
      }
    };
    var distanceInWordsLocaleFuture = {
      lessThanXSeconds: {
        one: 'manj kot {{count}} sekundo',
        two: 'manj kot {{count}} sekundi',
        few: 'manj kot {{count}} sekunde',
        other: 'manj kot {{count}} sekund'
      },
      xSeconds: {
        one: '{{count}} sekundo',
        two: '{{count}} sekundi',
        few: '{{count}} sekunde',
        other: '{{count}} sekund'
      },
      halfAMinute: 'pol minute',
      lessThanXMinutes: {
        one: 'manj kot {{count}} minuto',
        two: 'manj kot {{count}} minuti',
        few: 'manj kot {{count}} minute',
        other: 'manj kot {{count}} minut'
      },
      xMinutes: {
        one: '{{count}} minuto',
        two: '{{count}} minuti',
        few: '{{count}} minute',
        other: '{{count}} minut'
      },
      aboutXHours: {
        one: 'približno {{count}} uro',
        two: 'približno {{count}} uri',
        few: 'približno {{count}} ure',
        other: 'približno {{count}} ur'
      },
      xHours: {
        one: '{{count}} uro',
        two: '{{count}} uri',
        few: '{{count}} ure',
        other: '{{count}} ur'
      },
      xDays: {
        one: '{{count}} dan',
        two: '{{count}} dni',
        few: '{{count}} dni',
        other: '{{count}} dni'
      },
      aboutXMonths: {
        one: 'približno {{count}} mesec',
        two: 'približno {{count}} meseca',
        few: 'približno {{count}} mesece',
        other: 'približno {{count}} mesecev'
      },
      xMonths: {
        one: '{{count}} mesec',
        two: '{{count}} meseca',
        few: '{{count}} mesece',
        other: '{{count}} mesecev'
      },
      aboutXYears: {
        one: 'približno {{count}} leto',
        two: 'približno {{count}} leti',
        few: 'približno {{count}} leta',
        other: 'približno {{count}} let'
      },
      xYears: {
        one: '{{count}} leto',
        two: '{{count}} leti',
        few: '{{count}} leta',
        other: '{{count}} let'
      },
      overXYears: {
        one: 'več kot {{count}} leto',
        two: 'več kot {{count}} leti',
        few: 'več kot {{count}} leta',
        other: 'več kot {{count}} let'
      },
      almostXYears: {
        one: 'skoraj {{count}} leto',
        two: 'skoraj {{count}} leti',
        few: 'skoraj {{count}} leta',
        other: 'skoraj {{count}} let'
      }
    };

    function getFormFromCount(count) {
      switch (count % 100) {
        case 1:
          return 'one';

        case 2:
          return 'two';

        case 3:
        case 4:
          return 'few';

        default:
          return 'other';
      }
    }

    function formatDistance(token, count, options) {
      options = options || {};
      var localeObject = distanceInWordsLocale;
      var result = '';

      if (options.addSuffix) {
        if (options.comparison > 0) {
          localeObject = distanceInWordsLocaleFuture;
          result += 'čez ';
        } else {
          localeObject = distanceInWordsLocalePast;
          result += 'pred ';
        }
      }

      if (typeof localeObject[token] === 'string') {
        result += localeObject[token];
      } else {
        var form = getFormFromCount(count);
        result += localeObject[token][form].replace('{{count}}', count);
      }

      return result;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map