"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/sl/_lib/formatRelative/index", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = formatRelative;
    var formatRelativeLocale = {
      lastWeek: function (date) {
        var day = date.getUTCDay();

        switch (day) {
          case 0:
            return "'prejšnjo nedeljo ob' p";

          case 3:
            return "'prejšnjo sredo ob' p";

          case 6:
            return "'prejšnjo soboto ob' p";

          default:
            return "'prejšnji' EEEE 'ob' p";
        }
      },
      yesterday: "'včeraj ob' p",
      today: "'danes ob' p",
      tomorrow: "'jutri ob' p",
      nextWeek: function (date) {
        var day = date.getUTCDay();

        switch (day) {
          case 0:
            return "'naslednjo nedeljo ob' p";

          case 3:
            return "'naslednjo sredo ob' p";

          case 6:
            return "'naslednjo soboto ob' p";

          default:
            return "'naslednji' EEEE 'ob' p";
        }
      },
      other: 'P'
    };

    function formatRelative(token, date, _baseDate, _options) {
      var format = formatRelativeLocale[token];

      if (typeof format === 'function') {
        return format(date);
      }

      return format;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map