"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/zh-CN/_lib/formatRelative/index", ['module', 'exports', 'require', '../../../../_lib/isSameUTCWeek/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = formatRelative;

    var _index = _interopRequireDefault(require("../../../../_lib/isSameUTCWeek/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function checkWeek(_date, _baseDate, _options, baseFormat) {
      if ((0, _index.default)(_date, _baseDate, _options)) {
        return baseFormat; // in same week
      } else if (_date.getTime() > _baseDate.getTime()) {
        return "'下个'" + baseFormat; // in next week
      }

      return "'上个'" + baseFormat; // in last week
    }

    var formatRelativeLocale = {
      lastWeek: checkWeek,
      // days before yesterday, maybe in this week or last week
      yesterday: "'昨天' p",
      today: "'今天' p",
      tomorrow: "'明天' p",
      nextWeek: checkWeek,
      // days after tomorrow, maybe in this week or next week
      other: 'PP p'
    };

    function formatRelative(token, _date, _baseDate, _options) {
      var format = formatRelativeLocale[token];

      if (typeof format === 'function') {
        return format(_date, _baseDate, _options, 'eeee p');
      }

      return format;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map