"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/setDate/index", ['module', 'exports', 'require', '../_lib/toInteger/index', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = setDate;

    var _index = _interopRequireDefault(require("../_lib/toInteger/index"));

    var _index2 = _interopRequireDefault(require("../toDate/index"));

    var _index3 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name setDate
     * @category Day Helpers
     * @summary Set the day of the month to the given date.
     *
     * @description
     * Set the day of the month to the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to be changed
     * @param {Number} dayOfMonth - the day of the month of the new date
     * @returns {Date} the new date with the day of the month set
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Set the 30th day of the month to 1 September 2014:
     * var result = setDate(new Date(2014, 8, 1), 30)
     * //=> Tue Sep 30 2014 00:00:00
     */
    function setDate(dirtyDate, dirtyDayOfMonth) {
      (0, _index3.default)(2, arguments);
      var date = (0, _index2.default)(dirtyDate);
      var dayOfMonth = (0, _index.default)(dirtyDayOfMonth);
      date.setDate(dayOfMonth);
      return date;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map