"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/setHours/index", ['module', 'exports', 'require', '../_lib/toInteger/index', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = setHours;

    var _index = _interopRequireDefault(require("../_lib/toInteger/index"));

    var _index2 = _interopRequireDefault(require("../toDate/index"));

    var _index3 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name setHours
     * @category Hour Helpers
     * @summary Set the hours to the given date.
     *
     * @description
     * Set the hours to the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to be changed
     * @param {Number} hours - the hours of the new date
     * @returns {Date} the new date with the hours set
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Set 4 hours to 1 September 2014 11:30:00:
     * var result = setHours(new Date(2014, 8, 1, 11, 30), 4)
     * //=> Mon Sep 01 2014 04:30:00
     */
    function setHours(dirtyDate, dirtyHours) {
      (0, _index3.default)(2, arguments);
      var date = (0, _index2.default)(dirtyDate);
      var hours = (0, _index.default)(dirtyHours);
      date.setHours(hours);
      return date;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map