"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/setISOWeek/index", ['module', 'exports', 'require', '../_lib/toInteger/index', '../toDate/index', '../getISOWeek/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = setISOWeek;

    var _index = _interopRequireDefault(require("../_lib/toInteger/index"));

    var _index2 = _interopRequireDefault(require("../toDate/index"));

    var _index3 = _interopRequireDefault(require("../getISOWeek/index"));

    var _index4 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name setISOWeek
     * @category ISO Week Helpers
     * @summary Set the ISO week to the given date.
     *
     * @description
     * Set the ISO week to the given date, saving the weekday number.
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to be changed
     * @param {Number} isoWeek - the ISO week of the new date
     * @returns {Date} the new date with the ISO week set
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Set the 53rd ISO week to 7 August 2004:
     * var result = setISOWeek(new Date(2004, 7, 7), 53)
     * //=> Sat Jan 01 2005 00:00:00
     */
    function setISOWeek(dirtyDate, dirtyISOWeek) {
      (0, _index4.default)(2, arguments);
      var date = (0, _index2.default)(dirtyDate);
      var isoWeek = (0, _index.default)(dirtyISOWeek);
      var diff = (0, _index3.default)(date) - isoWeek;
      date.setDate(date.getDate() - diff * 7);
      return date;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map