"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/setSeconds/index", ['module', 'exports', 'require', '../_lib/toInteger/index', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = setSeconds;

    var _index = _interopRequireDefault(require("../_lib/toInteger/index"));

    var _index2 = _interopRequireDefault(require("../toDate/index"));

    var _index3 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name setSeconds
     * @category Second Helpers
     * @summary Set the seconds to the given date.
     *
     * @description
     * Set the seconds to the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to be changed
     * @param {Number} seconds - the seconds of the new date
     * @returns {Date} the new date with the seconds set
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Set 45 seconds to 1 September 2014 11:30:40:
     * var result = setSeconds(new Date(2014, 8, 1, 11, 30, 40), 45)
     * //=> Mon Sep 01 2014 11:30:45
     */
    function setSeconds(dirtyDate, dirtySeconds) {
      (0, _index3.default)(2, arguments);
      var date = (0, _index2.default)(dirtyDate);
      var seconds = (0, _index.default)(dirtySeconds);
      date.setSeconds(seconds);
      return date;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map