"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/setYear/index", ['module', 'exports', 'require', '../_lib/toInteger/index', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = setYear;

    var _index = _interopRequireDefault(require("../_lib/toInteger/index"));

    var _index2 = _interopRequireDefault(require("../toDate/index"));

    var _index3 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name setYear
     * @category Year Helpers
     * @summary Set the year to the given date.
     *
     * @description
     * Set the year to the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to be changed
     * @param {Number} year - the year of the new date
     * @returns {Date} the new date with the year set
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Set year 2013 to 1 September 2014:
     * var result = setYear(new Date(2014, 8, 1), 2013)
     * //=> Sun Sep 01 2013 00:00:00
     */
    function setYear(dirtyDate, dirtyYear) {
      (0, _index3.default)(2, arguments);
      var date = (0, _index2.default)(dirtyDate);
      var year = (0, _index.default)(dirtyYear); // Check if date is Invalid Date because Date.prototype.setFullYear ignores the value of Invalid Date

      if (isNaN(date)) {
        return new Date(NaN);
      }

      date.setFullYear(year);
      return date;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map