Liferay.Loader.define("change-tracking-web@1.0.46/publications/js/ChangeTrackingBaseScheduleView", ['module', 'exports', 'require', 'frontend-js-web', 'change-tracking-web$moment', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.ChangeTrackingBaseScheduleView = exports.default = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _moment = _interopRequireDefault(require("change-tracking-web$moment"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var ChangeTrackingBaseScheduleView = /*#__PURE__*/function (_React$Component) {
      _inherits(ChangeTrackingBaseScheduleView, _React$Component);

      function ChangeTrackingBaseScheduleView(props) {
        var _this;

        _classCallCheck(this, ChangeTrackingBaseScheduleView);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(ChangeTrackingBaseScheduleView).call(this, props));
        _this.handleDateChange = _this.handleDateChange.bind(_assertThisInitialized(_this));
        _this.handleTimeChange = _this.handleTimeChange.bind(_assertThisInitialized(_this));
        return _this;
      }

      _createClass(ChangeTrackingBaseScheduleView, [{
        key: "doSchedule",
        value: function doSchedule(scheduleURL) {
          var _this2 = this;

          this.setState({
            formError: null
          });
          var errorSet = false;

          if (!this.state.date) {
            this.setState({
              dateError: Liferay.Language.get('this-field-is-required')
            });
            errorSet = true;
          } else if (!this.isValidDate(this.state.date)) {
            this.setState({
              dateError: Liferay.Language.get('please-enter-a-valid-date')
            });
            errorSet = true;
          }

          if (!this.isValidTime(this.state.time)) {
            this.setState({
              timeError: Liferay.Language.get('this-field-is-required')
            });
            errorSet = true;
          }

          if (errorSet) {
            return;
          }

          var publishDate = this.getPublishDate(this.state.date, this.state.time);

          if (!this.isPublishDateInTheFuture(publishDate)) {
            this.setState({
              validationError: Liferay.Language.get('the-publish-time-must-be-in-the-future')
            });
            return;
          }

          AUI().use('liferay-portlet-url', function () {
            var portletURL = Liferay.PortletURL.createURL(scheduleURL);
            portletURL.setParameter('publishTime', publishDate.getTime());
            (0, _frontendJsWeb.fetch)(portletURL.toString(), {
              method: 'GET'
            }).then(function (response) {
              return response.json();
            }).then(function (json) {
              if (json.redirect) {
                Liferay.Util.navigate(json.redirect);
              } else if (json.validationError) {
                _this2.setState({
                  validationError: json.validationError
                });
              } else if (json.error) {
                _this2.setState({
                  formError: json.error
                });
              }
            }).catch(function (response) {
              _this2.setState({
                formError: response.error
              });
            });
          });
        }
      }, {
        key: "getDateClassName",
        value: function getDateClassName() {
          var className = 'input-group-item input-group-item-shrink';

          if (this.state.dateError || this.state.validationError) {
            return className + ' has-error';
          }

          return className;
        }
      }, {
        key: "getDateHelpText",
        value: function getDateHelpText() {
          if (this.state.validationError) {
            return (/*#__PURE__*/_react.default.createElement("div", {
                className: "help-block"
              }, /*#__PURE__*/_react.default.createElement("div", {
                className: "required",
                role: "alert"
              }, this.state.validationError))
            );
          } else if (this.state.dateError) {
            return (/*#__PURE__*/_react.default.createElement("div", {
                className: "help-block"
              }, /*#__PURE__*/_react.default.createElement("div", {
                className: "required",
                role: "alert"
              }, this.state.dateError))
            );
          }

          return '';
        }
      }, {
        key: "getPublishDate",
        value: function getPublishDate(date, time) {
          if (typeof date === 'string') {
            return new Date(date + ' ' + time.hours + ':' + time.minutes + ':00 ' + this.timeZone);
          }

          return new Date(date.getFullYear() + '-' + (date.getMonth() + 1) + '-' + date.getDate() + ' ' + time.hours + ':' + time.minutes + ':00 ' + this.timeZone);
        }
      }, {
        key: "getTimeClassName",
        value: function getTimeClassName() {
          var className = 'input-group-item';

          if (this.state.timeError || this.state.validationError) {
            return className + ' has-error';
          }

          return className;
        }
      }, {
        key: "getTimeHelpText",
        value: function getTimeHelpText() {
          if (this.state.timeError) {
            return (/*#__PURE__*/_react.default.createElement("div", {
                className: "help-block"
              }, /*#__PURE__*/_react.default.createElement("div", {
                className: "required",
                role: "alert"
              }, this.state.timeError))
            );
          }

          return '';
        }
      }, {
        key: "handleDateChange",
        value: function handleDateChange(date) {
          var validDate = this.isValidDate(date);

          if (this.state.validationError && (!validDate || this.isPublishDateInTheFuture(this.getPublishDate(date, this.state.time)))) {
            this.setState({
              validationError: null
            });
          }

          if (this.state.dateError && !this.state.date || this.state.dateError && validDate && !this.isValidDate(this.state.date)) {
            this.setState({
              dateError: null
            });
          }

          this.setState({
            date: date
          });
        }
      }, {
        key: "handleTimeChange",
        value: function handleTimeChange(time) {
          if (this.state.validationError && (!this.isValidTime(time) || this.isPublishDateInTheFuture(this.getPublishDate(this.state.date, time)))) {
            this.setState({
              validationError: null
            });
          }

          if (this.state.timeError && this.isValidTime(time) && !this.isValidTime(this.state.time)) {
            this.setState({
              timeError: null
            });
          }

          this.setState({
            time: time
          });
        }
      }, {
        key: "isPublishDateInTheFuture",
        value: function isPublishDateInTheFuture(publishDate) {
          var currentDate = new Date();

          if (currentDate.getTime() < publishDate.getTime()) {
            return true;
          }

          return false;
        }
      }, {
        key: "isValidDate",
        value: function isValidDate(date) {
          if (!date) {
            return false;
          }

          if (typeof date !== 'string') {
            return true;
          }

          var datePattern = /^[0-9][0-9][0-9][0-9]-[0-1]?[0-9]-[0-3]?[0-9]$/g;
          date = date.trim();

          if (date.match(datePattern) && (0, _moment.default)(date).isValid()) {
            return true;
          }

          return false;
        }
      }, {
        key: "isValidTime",
        value: function isValidTime(time) {
          if (time.hours !== '--' && time.minutes !== '--') {
            return true;
          }

          return false;
        }
      }]);

      return ChangeTrackingBaseScheduleView;
    }(_react.default.Component);

    exports.ChangeTrackingBaseScheduleView = ChangeTrackingBaseScheduleView;
    var _default = ChangeTrackingBaseScheduleView;
    exports.default = _default;
    //# sourceMappingURL=ChangeTrackingBaseScheduleView.js.map
  }
});
//# sourceMappingURL=ChangeTrackingBaseScheduleView.js.map