Liferay.Loader.define("change-tracking-web@1.0.46/publications/js/ChangeTrackingChangesView", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/breadcrumb', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/management-toolbar', '@frontend-taglib-clay$clayui/pagination-bar', '@frontend-taglib-clay$clayui/table', 'frontend-js-web', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

    var _breadcrumb = _interopRequireDefault(require("@frontend-taglib-clay$clayui/breadcrumb"));

    var _button = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = require("@frontend-taglib-clay$clayui/drop-down");

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _managementToolbar = _interopRequireDefault(require("@frontend-taglib-clay$clayui/management-toolbar"));

    var _paginationBar = require("@frontend-taglib-clay$clayui/pagination-bar");

    var _table = _interopRequireDefault(require("@frontend-taglib-clay$clayui/table"));

    var _frontendJsWeb = require("frontend-js-web");

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var ChangeTrackingChangesView = /*#__PURE__*/function (_React$Component) {
      _inherits(ChangeTrackingChangesView, _React$Component);

      function ChangeTrackingChangesView(props) {
        var _this;

        _classCallCheck(this, ChangeTrackingChangesView);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(ChangeTrackingChangesView).call(this, props));
        var activeCTCollection = props.activeCTCollection,
            changes = props.changes,
            contextView = props.contextView,
            ctCollectionId = props.ctCollectionId,
            discardURL = props.discardURL,
            models = props.models,
            namespace = props.namespace,
            pathParam = props.pathParam,
            renderCTEntryURL = props.renderCTEntryURL,
            renderDiffURL = props.renderDiffURL,
            rootDisplayClasses = props.rootDisplayClasses,
            showHideableParam = props.showHideableParam,
            siteNames = props.siteNames,
            spritemap = props.spritemap,
            typeNames = props.typeNames,
            userInfo = props.userInfo;
        _this.CHANGE_TYPE_ADDED = 'added';
        _this.CHANGE_TYPE_DELETED = 'deleted';
        _this.COLUMN_CHANGE_TYPE = 'CHANGE_TYPE';
        _this.COLUMN_MODIFIED_DATE = 'MODIFIED_DATE';
        _this.COLUMN_SITE = 'SITE';
        _this.COLUMN_TITLE = 'TITLE';
        _this.COLUMN_USER = 'USER';
        _this.FILTER_CLASS_EVERYTHING = 'everything';
        _this.GLOBAL_SITE_NAME = Liferay.Language.get('global');
        _this.MVC_RENDER_COMMAND_NAME = '/change_tracking/view_changes';
        _this.PARAM_CT_COLLECTION_ID = namespace + 'ctCollectionId';
        _this.PARAM_MVC_RENDER_COMMAND_NAME = namespace + 'mvcRenderCommandName';
        _this.PARAM_PATH = namespace + 'path';
        _this.PARAM_SHOW_HIDEABLE = namespace + 'showHideable';
        _this.POP_STATE = 'popstate';
        _this.VIEW_TYPE_CHANGES = 'changes';
        _this.VIEW_TYPE_CONTEXT = 'context';
        _this.activeCTCollection = activeCTCollection;
        _this.changes = changes;
        _this.contextView = contextView;
        _this.ctCollectionId = ctCollectionId;
        _this.discardURL = discardURL;
        _this.models = models;
        _this.renderCTEntryURL = renderCTEntryURL;
        _this.renderDiffURL = renderDiffURL;
        _this.rootDisplayClasses = rootDisplayClasses;
        _this.spritemap = spritemap;
        _this.userInfo = userInfo;

        _this._populateModelInfo(siteNames, typeNames);

        var pathState = _this._getPathState(pathParam);

        var filterClass = pathState.filterClass;
        var nodeId = pathState.nodeId;
        var viewType = pathState.viewType;

        var node = _this._getNode(filterClass, nodeId, viewType);

        var breadcrumbItems = _this._getBreadcrumbItems(node, filterClass, nodeId, viewType);

        var pathname = window.location.pathname;
        var search = window.location.search;
        var params = new URLSearchParams(search);

        if (_this._isWithinApp(params)) {
          var state = {
            path: pathname + search,
            senna: true
          };

          if (node.modelClassNameId) {
            state.modelClassNameId = node.modelClassNameId;
            state.modelClassPK = node.modelClassPK;
            _this.initialNode = node;
          }

          window.history.replaceState(state, document.title);
        }

        params.delete(_this.PARAM_PATH);
        params.delete(_this.PARAM_SHOW_HIDEABLE);
        _this.basePath = pathname + '?' + params.toString();
        var loading = false;

        if (node.modelClassNameId) {
          loading = true;
        }

        var showHideable = showHideableParam;

        if (node.hideable || filterClass !== _this.FILTER_CLASS_EVERYTHING && _this.contextView[filterClass].hideable) {
          showHideable = true;
        }

        _this.state = {
          ascending: true,
          breadcrumbItems: breadcrumbItems,
          children: _this._filterHideableNodes(node.children, showHideable),
          column: _this.COLUMN_TITLE,
          delta: 20,
          dropdownItems: null,
          filterClass: filterClass,
          loading: loading,
          node: node,
          page: 1,
          renderInnerHTML: null,
          showHideable: showHideable,
          sortDirectionClass: 'order-arrow-down-active',
          viewType: viewType
        };
        _this._handlePopState = _this._handlePopState.bind(_assertThisInitialized(_this));
        return _this;
      }

      _createClass(ChangeTrackingChangesView, [{
        key: "componentDidMount",
        value: function componentDidMount() {
          var _this2 = this;

          window.addEventListener(this.POP_STATE, this._handlePopState);

          if (Liferay.SPA && Liferay.SPA.app) {
            Liferay.SPA.app.skipLoadPopstate = true;
          }

          if (!this.initialNode || !this.state.node.modelClassNameId || this.state.node.modelClassNameId !== this.initialNode.modelClassNameId || this.state.node.modelClassPK !== this.initialNode.modelClassPK) {
            return;
          }

          AUI().use('liferay-portlet-url', function () {
            (0, _frontendJsWeb.fetch)(_this2._getRenderURL(_this2.state.node)).then(function (response) {
              return response.text();
            }).then(function (text) {
              if (!_this2._isWithinApp(new URLSearchParams(window.location.search))) {
                return;
              }

              var dropdownItems = _this2._getDropdownItems(_this2.state.node);

              var oldState = window.history.state;

              if (oldState && oldState.modelClassNameId && oldState.modelClassNameId === _this2.initialNode.modelClassNameId && oldState.modelClassPK === _this2.initialNode.modelClassPK) {
                window.history.replaceState({
                  dropdownItems: dropdownItems,
                  modelClassNameId: oldState.modelClassNameId,
                  modelClassPK: oldState.modelClassPK,
                  path: oldState.path,
                  renderInnerHTML: {
                    __html: text
                  },
                  senna: true
                }, document.title);
              }

              if (_this2.state.node.modelClassNameId && _this2.state.node.modelClassNameId === _this2.initialNode.modelClassNameId && _this2.state.node.modelClassPK === _this2.initialNode.modelClassPK) {
                _this2.setState({
                  dropdownItems: dropdownItems,
                  loading: false,
                  renderInnerHTML: {
                    __html: text
                  }
                });
              }
            });
          });
        }
      }, {
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
          window.removeEventListener(this.POP_STATE, this._handlePopState);

          if (Liferay.SPA && Liferay.SPA.app) {
            Liferay.SPA.app.skipLoadPopstate = false;
          }
        }
      }, {
        key: "_clone",
        value: function _clone(json) {
          var clone = {};
          var keys = Object.keys(json);

          for (var i = 0; i < keys.length; i++) {
            clone[keys[i]] = json[keys[i]];
          }

          return clone;
        }
      }, {
        key: "_filterDisplayNodes",
        value: function _filterDisplayNodes(nodes) {
          var _this3 = this;

          var ascending = this.state.ascending;

          if (this._getColumn() === this.COLUMN_CHANGE_TYPE) {
            nodes.sort(function (a, b) {
              if (a.changeType < b.changeType) {
                if (ascending) {
                  return -1;
                }

                return 1;
              }

              if (a.changeType > b.changeType) {
                if (ascending) {
                  return 1;
                }

                return -1;
              }

              var typeNameA = a.typeName.toUpperCase();
              var typeNameB = b.typeName.toUpperCase();

              if (typeNameA < typeNameB) {
                return -1;
              }

              if (typeNameA > typeNameB) {
                return 1;
              }

              if (a.title < b.title) {
                return -1;
              }

              if (a.title > b.title) {
                return 1;
              }

              return 0;
            });
          } else if (this._getColumn() === this.COLUMN_SITE) {
            nodes.sort(function (a, b) {
              if (a.siteName < b.siteName || a.siteName === _this3.GLOBAL_SITE_NAME && b.siteName !== _this3.GLOBAL_SITE_NAME) {
                if (ascending) {
                  return -1;
                }

                return 1;
              }

              if (a.siteName > b.siteName || a.siteName !== _this3.GLOBAL_SITE_NAME && b.siteName === _this3.GLOBAL_SITE_NAME) {
                if (ascending) {
                  return 1;
                }

                return -1;
              }

              var typeNameA = a.typeName.toUpperCase();
              var typeNameB = b.typeName.toUpperCase();

              if (typeNameA < typeNameB) {
                return -1;
              }

              if (typeNameA > typeNameB) {
                return 1;
              }

              if (a.title < b.title) {
                return -1;
              }

              if (a.title > b.title) {
                return 1;
              }

              return 0;
            });
          } else if (this._getColumn() === this.COLUMN_TITLE) {
            nodes.sort(function (a, b) {
              var typeNameA = a.typeName.toUpperCase();
              var typeNameB = b.typeName.toUpperCase();

              if (typeNameA < typeNameB) {
                return -1;
              }

              if (typeNameA > typeNameB) {
                return 1;
              }

              if (a.title < b.title) {
                if (ascending) {
                  return -1;
                }

                return 1;
              }

              if (a.title > b.title) {
                if (ascending) {
                  return 1;
                }

                return -1;
              }

              return 0;
            });
          } else if (this._getColumn() === this.COLUMN_USER) {
            nodes.sort(function (a, b) {
              if (a.userName < b.userName) {
                if (ascending) {
                  return -1;
                }

                return 1;
              }

              if (a.userName > b.userName) {
                if (ascending) {
                  return 1;
                }

                return -1;
              }

              var typeNameA = a.typeName.toUpperCase();
              var typeNameB = b.typeName.toUpperCase();

              if (typeNameA < typeNameB) {
                return -1;
              }

              if (typeNameA > typeNameB) {
                return 1;
              }

              if (a.title < b.title) {
                return -1;
              }

              if (a.title > b.title) {
                return 1;
              }

              return 0;
            });
          } else {
            nodes.sort(function (a, b) {
              if (a.modifiedTime < b.modifiedTime) {
                if (ascending) {
                  return -1;
                }

                return 1;
              }

              if (a.modifiedTime > b.modifiedTime) {
                if (ascending) {
                  return 1;
                }

                return -1;
              }

              return 0;
            });
          }

          if (nodes.length > 5) {
            nodes = nodes.slice(this.state.delta * (this.state.page - 1), this.state.delta * this.state.page);
          }

          if (this._getColumn() === this.COLUMN_MODIFIED_DATE) {
            nodes.sort(function (a, b) {
              var typeNameA = a.typeName.toUpperCase();
              var typeNameB = b.typeName.toUpperCase();

              if (typeNameA < typeNameB) {
                return -1;
              }

              if (typeNameA > typeNameB) {
                return 1;
              }

              if (a.modifiedTime < b.modifiedTime) {
                if (ascending) {
                  return -1;
                }

                return 1;
              }

              if (a.modifiedTime > b.modifiedTime) {
                if (ascending) {
                  return 1;
                }

                return -1;
              }

              return 0;
            });
          }

          return nodes;
        }
      }, {
        key: "_filterHideableNodes",
        value: function _filterHideableNodes(nodes, showHideable) {
          if (!nodes || showHideable) {
            return nodes;
          }

          var filterNodes = [];

          for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];

            if (!node.hideable) {
              filterNodes.push(node);
            }
          }

          return filterNodes;
        }
      }, {
        key: "_format",
        value: function _format(key, args) {
          var SPLIT_REGEX = /({\d+})/g;
          var keyArray = key.split(SPLIT_REGEX).filter(function (val) {
            return val.length !== 0;
          });

          for (var i = 0; i < args.length; i++) {
            var arg = args[i];
            var indexKey = "{".concat(i, "}");
            var argIndex = keyArray.indexOf(indexKey);

            while (argIndex >= 0) {
              keyArray.splice(argIndex, 1, arg);
              argIndex = keyArray.indexOf(indexKey);
            }
          }

          return keyArray.join('');
        }
      }, {
        key: "_getBreadcrumbItems",
        value: function _getBreadcrumbItems(node, filterClass, nodeId, viewType) {
          var _this4 = this;

          if (viewType === this.VIEW_TYPE_CHANGES) {
            if (nodeId === 0) {
              return [{
                active: true,
                label: Liferay.Language.get('home')
              }];
            }

            return [{
              label: Liferay.Language.get('home'),
              onClick: function onClick() {
                return _this4._handleNavigationUpdate({
                  nodeId: 0
                });
              }
            }, {
              active: true,
              label: node.title,
              modelClassNameId: node.modelClassNameId,
              modelClassPK: node.modelClassPK
            }];
          }

          var breadcrumbItems = [];
          var homeBreadcrumbItem = {
            label: Liferay.Language.get('home')
          };

          if (filterClass === this.FILTER_CLASS_EVERYTHING && nodeId === 0) {
            homeBreadcrumbItem.active = true;
            breadcrumbItems.push(homeBreadcrumbItem);
            return breadcrumbItems;
          }

          homeBreadcrumbItem.onClick = function () {
            return _this4._handleNavigationUpdate({
              filterClass: _this4.FILTER_CLASS_EVERYTHING,
              nodeId: 0
            });
          };

          breadcrumbItems.push(homeBreadcrumbItem);
          var showParent = false;

          if (filterClass === this.FILTER_CLASS_EVERYTHING) {
            showParent = true;
          } else {
            var label = filterClass;

            if (label.includes('.')) {
              label = label.substring(label.lastIndexOf('.') + 1, label.length);
            }

            var rootDisplayClassBreadcrumb = {
              label: label
            };

            if (nodeId === 0) {
              rootDisplayClassBreadcrumb.active = true;
              breadcrumbItems.push(rootDisplayClassBreadcrumb);
              return breadcrumbItems;
            }

            rootDisplayClassBreadcrumb.onClick = function () {
              return _this4._handleNavigationUpdate({
                filterClass: filterClass,
                nodeId: 0
              });
            };

            breadcrumbItems.push(rootDisplayClassBreadcrumb);
          }

          if (!node.parents) {
            return null;
          }

          var _loop = function _loop(i) {
            var parent = node.parents[i];

            if (parent.typeName === filterClass) {
              showParent = true;
            }

            if (!showParent) {
              return "continue";
            }

            breadcrumbItems.push({
              hideable: parent.hideable,
              label: parent.title,
              modelClassNameId: parent.modelClassNameId,
              modelClassPK: parent.modelClassPK,
              nodeId: parent.nodeId,
              onClick: function onClick() {
                return _this4._handleNavigationUpdate({
                  filterClass: filterClass,
                  nodeId: parent.nodeId
                });
              }
            });
          };

          for (var i = 0; i < node.parents.length; i++) {
            var _ret = _loop(i);

            if (_ret === "continue") continue;
          }

          breadcrumbItems.push({
            active: true,
            label: node.title,
            modelClassNameId: node.modelClassNameId,
            modelClassPK: node.modelClassPK
          });
          return breadcrumbItems;
        }
      }, {
        key: "_getColumn",
        value: function _getColumn() {
          if (this.state.viewType === this.VIEW_TYPE_CONTEXT) {
            return this.COLUMN_TITLE;
          }

          return this.state.column;
        }
      }, {
        key: "_getDiscardURL",
        value: function _getDiscardURL(node) {
          var portletURL = Liferay.PortletURL.createURL(this.discardURL);
          portletURL.setParameter('modelClassNameId', node.modelClassNameId);
          portletURL.setParameter('modelClassPK', node.modelClassPK);
          return portletURL.toString();
        }
      }, {
        key: "_getDropdownItems",
        value: function _getDropdownItems(node) {
          var dropdownItems = node.dropdownItems;

          if (!dropdownItems) {
            dropdownItems = [];
          } else {
            dropdownItems = dropdownItems.slice(0);
          }

          if (this.activeCTCollection) {
            dropdownItems.push({
              href: this._getDiscardURL(node),
              label: Liferay.Language.get('discard'),
              symbolLeft: 'times-circle'
            });
          }

          return dropdownItems;
        }
      }, {
        key: "_getModels",
        value: function _getModels(nodes) {
          if (!nodes) {
            return [];
          }

          var models = [];

          for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            var modelKey = node;
            var nodeId = node;

            if (_typeof(node) === 'object') {
              modelKey = node.modelKey;
              nodeId = node.nodeId;
            }

            var model = this._clone(this.models[modelKey.toString()]);

            model.nodeId = nodeId;
            models.push(model);
          }

          return models;
        }
      }, {
        key: "_getNode",
        value: function _getNode(filterClass, nodeId, viewType) {
          if (viewType === this.VIEW_TYPE_CHANGES) {
            if (nodeId === 0) {
              return {
                children: this._getModels(this.changes)
              };
            }

            return this._clone(this.models[nodeId.toString()]);
          } else if (filterClass !== this.FILTER_CLASS_EVERYTHING && nodeId === 0) {
            return {
              children: this._getModels(this.contextView[filterClass].children)
            };
          }

          var rootNode = this.contextView.everything;

          if (nodeId === 0) {
            return {
              children: this._getModels(rootNode.children)
            };
          }

          if (!rootNode.parents) {
            rootNode.parents = [];

            for (var i = 0; i < rootNode.children.length; i++) {
              rootNode.children[i].parents = [];
            }
          }

          var stack = [rootNode];

          while (stack.length > 0) {
            var element = stack.pop();

            if (element.nodeId === nodeId) {
              var entry = this._clone(this.models[element.modelKey.toString()]);

              entry.children = this._getModels(element.children);
              entry.nodeId = nodeId;
              entry.parents = element.parents;
              return entry;
            } else if (!element.children) {
              continue;
            }

            for (var _i = 0; _i < element.children.length; _i++) {
              var child = element.children[_i];

              if (!child.parents) {
                var parents = element.parents.slice(0);
                var model = this.models[element.modelKey.toString()];
                parents.push({
                  hideable: model.hideable,
                  modelClassNameId: model.modelClassNameId,
                  modelClassPK: model.modelClassPK,
                  nodeId: element.nodeId,
                  title: model.title,
                  typeName: model.typeName
                });
                child.parents = parents;
              }

              stack.push(child);
            }
          }

          return null;
        }
      }, {
        key: "_getPath",
        value: function _getPath(pathParam, showHideable) {
          return this.basePath + '&' + this.PARAM_PATH + '=' + pathParam + '&' + this.PARAM_SHOW_HIDEABLE + '=' + showHideable.toString();
        }
      }, {
        key: "_getPathParam",
        value: function _getPathParam(breadcrumbItems, filterClass, viewType) {
          var path = viewType + '/' + filterClass;

          if (breadcrumbItems && breadcrumbItems.length > 0) {
            var tree = '';

            for (var i = 0; i < breadcrumbItems.length; i++) {
              var breadcrumbItem = breadcrumbItems[i];

              if (breadcrumbItem.modelClassNameId) {
                tree += '/' + breadcrumbItem.modelClassNameId.toString() + '-' + breadcrumbItem.modelClassPK.toString();
              }
            }

            path += tree;
          }

          return path;
        }
      }, {
        key: "_getPortraitURL",
        value: function _getPortraitURL(node) {
          return this.userInfo[node.userId.toString()].portraitURL;
        }
      }, {
        key: "_getRenderURL",
        value: function _getRenderURL(node) {
          if (node.ctEntryId) {
            var _portletURL = Liferay.PortletURL.createURL(this.renderDiffURL);

            _portletURL.setParameter('ctEntryId', node.ctEntryId);

            return _portletURL.toString();
          }

          var portletURL = Liferay.PortletURL.createURL(this.renderCTEntryURL);
          portletURL.setParameter('modelClassNameId', node.modelClassNameId);
          portletURL.setParameter('modelClassPK', node.modelClassPK);
          return portletURL.toString();
        }
      }, {
        key: "_getRootDisplayOptions",
        value: function _getRootDisplayOptions() {
          var rootDisplayOptions = [];
          rootDisplayOptions.push( /*#__PURE__*/_react.default.createElement(_form.ClayRadio, {
            label: Liferay.Language.get('everything'),
            value: this.FILTER_CLASS_EVERYTHING
          }));

          for (var i = 0; i < this.rootDisplayClasses.length; i++) {
            var className = this.rootDisplayClasses[i];

            if (!this.state.showHideable && this.contextView[className].hideable) {
              continue;
            }

            var label = className;

            if (label.includes('.')) {
              label = label.substring(label.lastIndexOf('.') + 1, label.length);
            }

            rootDisplayOptions.push( /*#__PURE__*/_react.default.createElement(_form.ClayRadio, {
              label: label,
              value: className
            }));
          }

          return rootDisplayOptions;
        }
      }, {
        key: "_getPathState",
        value: function _getPathState(pathParam) {
          if (!pathParam) {
            return {
              filterClass: this.FILTER_CLASS_EVERYTHING,
              nodeId: 0,
              viewType: this.VIEW_TYPE_CHANGES
            };
          }

          var parts = pathParam.split('/');
          var path = [];

          if (parts.length > 2) {
            for (var i = 2; i < parts.length; i++) {
              var part = parts[i];
              var keys = part.split('-');
              path.push({
                modelClassNameId: keys[0],
                modelClassPK: keys[1]
              });
            }
          }

          var pathState = {
            filterClass: parts[1],
            nodeId: 0,
            viewType: parts[0]
          };

          if (pathState.filterClass !== this.FILTER_CLASS_EVERYTHING && !this.contextView[pathState.filterClass]) {
            pathState.filterClass = this.FILTER_CLASS_EVERYTHING;
          } else if (pathState.viewType === this.VIEW_TYPE_CHANGES && path.length > 0) {
            var modelClassNameId = path[0].modelClassNameId;
            var modelClassPK = path[0].modelClassPK;

            for (var _i2 = 0; _i2 < this.changes.length; _i2++) {
              var modelKey = this.changes[_i2];
              var model = this.models[modelKey.toString()];

              if (modelClassNameId === model.modelClassNameId && modelClassPK === model.modelClassPK) {
                pathState.nodeId = modelKey;
              }
            }
          } else if (pathState.viewType === this.VIEW_TYPE_CONTEXT) {
            var contextNode = this.contextView.everything;

            if (pathState.filterClass !== this.FILTER_CLASS_EVERYTHING) {
              contextNode = this.contextView[pathState.filterClass];
            }

            for (var _i3 = 0; _i3 < path.length; _i3++) {
              if (!contextNode.children) {
                break;
              }

              var sessionNode = path[_i3];

              for (var j = 0; j < contextNode.children.length; j++) {
                var child = contextNode.children[j];
                var _model = this.models[child.modelKey.toString()];

                if (_model.modelClassNameId === sessionNode.modelClassNameId && _model.modelClassPK === sessionNode.modelClassPK) {
                  if (pathState.filterClass !== this.FILTER_CLASS_EVERYTHING && _i3 === 0) {
                    var stack = [this.contextView.everything];

                    while (stack.length > 0) {
                      var element = stack.pop();

                      if (element.nodeId === child.nodeId) {
                        contextNode = element;
                        break;
                      } else if (!element.children) {
                        continue;
                      }

                      for (var _i4 = 0; _i4 < element.children.length; _i4++) {
                        stack.push(element.children[_i4]);
                      }
                    }
                  } else {
                    contextNode = child;
                  }

                  pathState.nodeId = contextNode.nodeId;
                  break;
                }
              }
            }
          }

          return pathState;
        }
      }, {
        key: "_getTableHead",
        value: function _getTableHead() {
          if (this.state.viewType === this.VIEW_TYPE_CONTEXT) {
            return '';
          }

          return (/*#__PURE__*/_react.default.createElement(_table.default.Head, null, /*#__PURE__*/_react.default.createElement(_table.default.Row, null, /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
              headingCell: true
            }, Liferay.Language.get('user')), /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
              headingCell: true
            }, Liferay.Language.get('site')), /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
              className: "table-cell-expand",
              headingCell: true
            }, Liferay.Language.get('title')), /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
              className: "table-cell-expand-smallest",
              headingCell: true
            }, Liferay.Language.get('change-type')), /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
              className: "table-cell-expand-smallest",
              headingCell: true
            }, Liferay.Language.get('last-modified'))))
          );
        }
      }, {
        key: "_getTableRows",
        value: function _getTableRows(nodes) {
          var _this5 = this;

          var rows = [];

          if (!nodes) {
            return rows;
          }

          var currentTypeName = '';

          var _loop2 = function _loop2(i) {
            var node = nodes[i];

            if (node.typeName !== currentTypeName) {
              currentTypeName = node.typeName;
              rows.push( /*#__PURE__*/_react.default.createElement(_table.default.Row, {
                divider: true
              }, /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
                colSpan: _this5.state.viewType === _this5.VIEW_TYPE_CHANGES ? 5 : 1
              }, node.typeName)));
            }

            var cells = [];

            if (_this5.state.viewType === _this5.VIEW_TYPE_CONTEXT) {
              var descriptionMarkup = '';

              if (node.description) {
                descriptionMarkup = /*#__PURE__*/_react.default.createElement("div", {
                  className: "publication-description"
                }, node.description);
              }

              cells.push( /*#__PURE__*/_react.default.createElement(_table.default.Cell, null, /*#__PURE__*/_react.default.createElement("div", {
                className: "publication-name"
              }, node.title), descriptionMarkup));
            } else {
              var portraitURL = _this5._getPortraitURL(node);

              if (portraitURL) {
                cells.push( /*#__PURE__*/_react.default.createElement(_table.default.Cell, null, /*#__PURE__*/_react.default.createElement("span", {
                  className: "lfr-portal-tooltip",
                  title: node.userName
                }, /*#__PURE__*/_react.default.createElement("span", {
                  className: "rounded-circle sticker sticker-primary"
                }, /*#__PURE__*/_react.default.createElement("span", {
                  className: "sticker-overlay"
                }, /*#__PURE__*/_react.default.createElement("img", {
                  alt: "thumbnail",
                  className: "img-fluid",
                  src: portraitURL
                }))))));
              } else {
                var userPortraitCss = 'sticker sticker-circle sticker-light user-icon-color-';
                userPortraitCss += node.userId % 10;
                cells.push( /*#__PURE__*/_react.default.createElement(_table.default.Cell, null, /*#__PURE__*/_react.default.createElement("span", {
                  className: "lfr-portal-tooltip",
                  title: node.userName
                }, /*#__PURE__*/_react.default.createElement("span", {
                  className: userPortraitCss
                }, /*#__PURE__*/_react.default.createElement("span", {
                  className: "inline-item"
                }, /*#__PURE__*/_react.default.createElement("svg", {
                  className: "lexicon-icon"
                }, /*#__PURE__*/_react.default.createElement("use", {
                  href: _this5.spritemap + '#user'
                })))))));
              }

              cells.push( /*#__PURE__*/_react.default.createElement(_table.default.Cell, null, node.siteName));
              cells.push( /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
                className: "publication-name table-cell-expand"
              }, node.title));
              cells.push( /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
                className: "table-cell-expand-smallest"
              }, node.changeTypeLabel));
              cells.push( /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
                className: "table-cell-expand-smallest"
              }, _this5._format(Liferay.Language.get('x-ago'), [node.timeDescription])));
            }

            rows.push( /*#__PURE__*/_react.default.createElement(_table.default.Row, {
              className: "cursor-pointer",
              onClick: function onClick() {
                return _this5._handleNavigationUpdate({
                  nodeId: node.nodeId
                });
              }
            }, cells));
          };

          for (var i = 0; i < nodes.length; i++) {
            _loop2(i);
          }

          return rows;
        }
      }, {
        key: "_getViewTypes",
        value: function _getViewTypes() {
          var _this6 = this;

          if (!this.contextView) {
            return '';
          }

          var items = [{
            active: this.state.viewType === this.VIEW_TYPE_CHANGES,
            label: Liferay.Language.get('changes'),
            onClick: function onClick() {
              return _this6._handleNavigationUpdate({
                filterClass: _this6.FILTER_CLASS_EVERYTHING,
                nodeId: 0,
                viewType: _this6.VIEW_TYPE_CHANGES
              });
            },
            symbolLeft: 'list'
          }, {
            active: this.state.viewType === this.VIEW_TYPE_CONTEXT,
            label: Liferay.Language.get('context'),
            onClick: function onClick() {
              return _this6._handleNavigationUpdate({
                filterClass: _this6.FILTER_CLASS_EVERYTHING,
                nodeId: 0,
                viewType: _this6.VIEW_TYPE_CONTEXT
              });
            },
            symbolLeft: 'pages-tree'
          }];
          return (/*#__PURE__*/_react.default.createElement(_managementToolbar.default.Item, {
              className: "lfr-portal-tooltip",
              title: Liferay.Language.get('display-style')
            }, /*#__PURE__*/_react.default.createElement(_dropDown.ClayDropDownWithItems, {
              alignmentPosition: _dropDown.Align.BottomLeft,
              items: items,
              spritemap: this.spritemap,
              trigger: /*#__PURE__*/_react.default.createElement(_button.default, {
                className: "nav-link nav-link-monospaced",
                displayType: "unstyled"
              }, /*#__PURE__*/_react.default.createElement(_icon.default, {
                spritemap: this.spritemap,
                symbol: this.state.viewType === this.VIEW_TYPE_CHANGES ? 'list' : 'pages-tree'
              }))
            }))
          );
        }
      }, {
        key: "_handleDeltaChange",
        value: function _handleDeltaChange(delta) {
          this.setState({
            delta: delta,
            page: 1
          });
        }
      }, {
        key: "_handleNavigationUpdate",
        value: function _handleNavigationUpdate(json) {
          var _this7 = this;

          var filterClass = json.filterClass;

          if (!filterClass) {
            filterClass = this.state.filterClass;
          }

          var nodeId = json.nodeId;
          var showHideable = this.state.showHideable;

          if (Object.prototype.hasOwnProperty.call(json, 'showHideable')) {
            showHideable = json.showHideable;
          }

          var viewType = json.viewType;

          if (!viewType) {
            viewType = this.state.viewType;
          }

          if (viewType === this.VIEW_TYPE_CONTEXT && this.contextView.errorMessage) {
            this.setState({
              renderInnerHTML: null,
              viewType: viewType
            });
            return;
          }

          var node = this._getNode(filterClass, nodeId, viewType);

          var breadcrumbItems = this._getBreadcrumbItems(node, filterClass, nodeId, viewType);

          var pathParam = this._getPathParam(breadcrumbItems, filterClass, viewType);

          var path = this._getPath(pathParam, showHideable);

          var state = {
            path: path,
            senna: true
          };

          if (node.modelClassNameId) {
            state.modelClassNameId = node.modelClassNameId;
            state.modelClassPK = node.modelClassPK;
          }

          window.history.pushState(state, document.title, path);
          this.setState({
            breadcrumbItems: breadcrumbItems,
            children: this._filterHideableNodes(node.children, showHideable),
            filterClass: filterClass,
            node: node,
            page: 1,
            showHideable: showHideable,
            viewType: viewType
          }, function () {
            return _this7._updateRenderContent(true, node, path);
          });
        }
      }, {
        key: "_handlePageChange",
        value: function _handlePageChange(page) {
          this.setState({
            page: page
          });
        }
      }, {
        key: "_handlePopState",
        value: function _handlePopState(event) {
          var _this8 = this;

          var state = event.state;
          var pathname = window.location.pathname;
          var search = window.location.search;

          if (state) {
            var index = state.path.indexOf('?');
            pathname = state.path.substring(0, index);

            if (index < 0) {
              if (Liferay.SPA && Liferay.SPA.app) {
                Liferay.SPA.app.skipLoadPopstate = false;
                Liferay.SPA.app.navigate(window.location.href, true);
              }

              return;
            }

            search = state.path.substring(index, state.path.length);
          }

          var params = new URLSearchParams(search);

          if (!this._isWithinApp(params)) {
            if (Liferay.SPA && Liferay.SPA.app) {
              Liferay.SPA.app.skipLoadPopstate = false;
              Liferay.SPA.app.navigate(window.location.href, true);
            }

            return;
          }

          var pathState = this._getPathState(params.get(this.PARAM_PATH));

          var filterClass = pathState.filterClass;
          var nodeId = pathState.nodeId;
          var viewType = pathState.viewType;

          if (viewType === this.VIEW_TYPE_CONTEXT && this.contextView.errorMessage) {
            this.setState({
              renderInnerHTML: null,
              viewType: viewType
            });
            return;
          }

          var node = this._getNode(filterClass, nodeId, viewType);

          var breadcrumbItems = this._getBreadcrumbItems(node, filterClass, nodeId, viewType);

          var showHideable = this.state.showHideable;

          if (node.hideable || filterClass !== this.FILTER_CLASS_EVERYTHING && this.contextView[filterClass].hideable) {
            showHideable = true;
          }

          this.setState({
            breadcrumbItems: breadcrumbItems,
            children: this._filterHideableNodes(node.children, showHideable),
            filterClass: filterClass,
            node: node,
            page: 1,
            showHideable: showHideable,
            viewType: viewType
          }, function () {
            if (!state || !state.renderInnerHTML) {
              _this8._updateRenderContent(true, node, pathname + search);

              return;
            }

            _this8.setState({
              dropdownItems: state.dropdownItems,
              renderInnerHTML: state.renderInnerHTML
            }, function () {
              _this8._updateRenderContent(false, node, pathname + search);
            });
          });
        }
      }, {
        key: "_handleShowHideableToggle",
        value: function _handleShowHideableToggle(showHideable) {
          if (!showHideable) {
            if (this.state.viewType === this.VIEW_TYPE_CONTEXT && this.contextView[this.state.filterClass].hideable) {
              this._handleNavigationUpdate({
                filterClass: this.FILTER_CLASS_EVERYTHING,
                nodeId: 0,
                showHideable: showHideable
              });

              return;
            } else if (this.state.node.hideable) {
              var nodeId = 0;

              for (var i = this.state.breadcrumbItems.length - 2; i > 0; i--) {
                var breadcrumbItem = this.state.breadcrumbItems[i];

                if (!breadcrumbItem.hideable) {
                  if (breadcrumbItem.nodeId) {
                    nodeId = breadcrumbItem.nodeId;
                  }

                  break;
                }
              }

              this._handleNavigationUpdate({
                nodeId: nodeId,
                showHideable: showHideable
              });

              return;
            }
          }

          var oldState = window.history.state;

          var newPathParam = this._getPathParam(this.state.breadcrumbItems, this.state.filterClass, this.state.viewType);

          var params = new URLSearchParams(window.location.search);
          var oldPathParam = params.get(this.PARAM_PATH);

          if (this._isWithinApp(params) && (!oldPathParam || oldPathParam === newPathParam)) {
            var path = this._getPath(newPathParam, showHideable);

            var newState = {
              path: path,
              senna: true
            };

            if (oldState) {
              newState = this._clone(oldState);
              newState.path = path;
            }

            window.history.replaceState(newState, document.title, path);
          }

          this.setState({
            children: this._filterHideableNodes(this.state.node.children, showHideable),
            showHideable: showHideable
          });
        }
      }, {
        key: "_handleSortColumnChange",
        value: function _handleSortColumnChange(column) {
          this.setState({
            column: column
          });
        }
      }, {
        key: "_handleSortDirectionChange",
        value: function _handleSortDirectionChange() {
          if (this.state.ascending) {
            this.setState({
              ascending: false,
              sortDirectionClass: 'order-arrow-up-active'
            });
            return;
          }

          this.setState({
            ascending: true,
            sortDirectionClass: 'order-arrow-down-active'
          });
        }
      }, {
        key: "_isWithinApp",
        value: function _isWithinApp(params) {
          var ctCollectionId = params.get(this.PARAM_CT_COLLECTION_ID);
          var mvcRenderCommandName = params.get(this.PARAM_MVC_RENDER_COMMAND_NAME);

          if (ctCollectionId && ctCollectionId === this.ctCollectionId.toString() && mvcRenderCommandName && mvcRenderCommandName === this.MVC_RENDER_COMMAND_NAME) {
            return true;
          }

          return false;
        }
      }, {
        key: "_populateModelInfo",
        value: function _populateModelInfo(siteNames, typeNames) {
          var keys = Object.keys(this.models);

          for (var i = 0; i < keys.length; i++) {
            var model = this.models[keys[i]];

            if (model.groupId) {
              model.siteName = siteNames[model.groupId.toString()];
            } else {
              model.siteName = this.GLOBAL_SITE_NAME;
            }

            model.typeName = typeNames[model.modelClassNameId.toString()];

            if (model.ctEntryId) {
              model.changeTypeLabel = Liferay.Language.get('modified');

              if (model.changeType === this.CHANGE_TYPE_ADDED) {
                model.changeTypeLabel = Liferay.Language.get('added');
              } else if (model.changeType === this.CHANGE_TYPE_DELETED) {
                model.changeTypeLabel = Liferay.Language.get('deleted');
              }

              model.userName = this.userInfo[model.userId.toString()].userName;

              if (model.siteName === this.GLOBAL_SITE_NAME) {
                var key = Liferay.Language.get('x-modified-a-x-x-ago');

                if (model.changeType === this.CHANGE_TYPE_ADDED) {
                  key = Liferay.Language.get('x-added-a-x-x-ago');
                } else if (model.changeType === this.CHANGE_TYPE_DELETED) {
                  key = Liferay.Language.get('x-deleted-a-x-x-ago');
                }

                model.description = this._format(key, [model.userName, model.typeName, model.timeDescription]);
              } else {
                var _key = Liferay.Language.get('x-modified-a-x-in-x-x-ago');

                if (model.changeType === this.CHANGE_TYPE_ADDED) {
                  _key = Liferay.Language.get('x-added-a-x-in-x-x-ago');
                } else if (model.changeType === this.CHANGE_TYPE_DELETED) {
                  _key = Liferay.Language.get('x-deleted-a-x-in-x-x-ago');
                }

                model.description = this._format(_key, [model.userName, model.typeName, model.siteName, model.timeDescription]);
              }
            }
          }

          for (var _i5 = 0; _i5 < this.rootDisplayClasses.length; _i5++) {
            var rootDisplayClassInfo = this.contextView[this.rootDisplayClasses[_i5]];
            var hideable = true;

            for (var _i6 = 0; _i6 < rootDisplayClassInfo.children.length; _i6++) {
              var _model2 = this.models[rootDisplayClassInfo.children[_i6].modelKey.toString()];

              if (!_model2.hideable) {
                hideable = false;
              }
            }

            rootDisplayClassInfo.hideable = hideable;
          }
        }
      }, {
        key: "_renderEntry",
        value: function _renderEntry() {
          if (this.state.renderInnerHTML === null) {
            if (this.state.loading) {
              return (/*#__PURE__*/_react.default.createElement("span", {
                  "aria-hidden": "true",
                  className: "loading-animation"
                })
              );
            }

            return '';
          }

          return (/*#__PURE__*/_react.default.createElement("div", {
              className: this.state.loading ? 'sheet publications-sheet-loading' : 'sheet'
            }, /*#__PURE__*/_react.default.createElement("h2", {
              className: "autofit-row sheet-title"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "autofit-col autofit-col-expand"
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "heading-text"
            }, this.state.node.description ? this.state.node.description : this.state.node.title)), this.state.dropdownItems && this.state.dropdownItems.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
              className: "autofit-col"
            }, /*#__PURE__*/_react.default.createElement(_dropDown.ClayDropDownWithItems, {
              alignmentPosition: _dropDown.Align.BottomLeft,
              items: this.state.dropdownItems,
              spritemap: this.spritemap,
              trigger: /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
                displayType: "unstyled",
                small: true,
                spritemap: this.spritemap,
                symbol: "ellipsis-v"
              })
            }))), /*#__PURE__*/_react.default.createElement("div", {
              className: "sheet-section"
            }, this.state.loading && /*#__PURE__*/_react.default.createElement("div", {
              className: "publications-loading-animation-wrapper"
            }, /*#__PURE__*/_react.default.createElement("span", {
              "aria-hidden": "true",
              className: "loading-animation"
            })), /*#__PURE__*/_react.default.createElement("div", {
              dangerouslySetInnerHTML: this.state.renderInnerHTML
            })))
          );
        }
      }, {
        key: "_renderManagementToolbar",
        value: function _renderManagementToolbar() {
          var _this9 = this;

          var items = [];

          if (this.state.viewType === this.VIEW_TYPE_CHANGES) {
            items = [{
              active: this._getColumn() === this.COLUMN_CHANGE_TYPE,
              label: Liferay.Language.get('change-type'),
              onClick: function onClick() {
                return _this9._handleSortColumnChange(_this9.COLUMN_CHANGE_TYPE);
              }
            }, {
              active: this._getColumn() === this.COLUMN_MODIFIED_DATE,
              label: Liferay.Language.get('modified-date'),
              onClick: function onClick() {
                return _this9._handleSortColumnChange(_this9.COLUMN_MODIFIED_DATE);
              }
            }, {
              active: this._getColumn() === this.COLUMN_SITE,
              label: Liferay.Language.get('site'),
              onClick: function onClick() {
                return _this9._handleSortColumnChange(_this9.COLUMN_SITE);
              }
            }, {
              active: this._getColumn() === this.COLUMN_USER,
              label: Liferay.Language.get('user'),
              onClick: function onClick() {
                return _this9._handleSortColumnChange(_this9.COLUMN_USER);
              }
            }];
          }

          items.push({
            active: this._getColumn() === this.COLUMN_TITLE,
            label: Liferay.Language.get('title'),
            onClick: function onClick() {
              return _this9._handleSortColumnChange(_this9.COLUMN_TITLE);
            }
          });
          items.sort(function (a, b) {
            if (a.label < b.label) {
              return -1;
            }

            return 1;
          });
          var dropdownItems = [{
            items: items,
            label: Liferay.Language.get('order-by'),
            type: 'group'
          }];
          return (/*#__PURE__*/_react.default.createElement(_managementToolbar.default, null, /*#__PURE__*/_react.default.createElement(_managementToolbar.default.ItemList, null, /*#__PURE__*/_react.default.createElement(_managementToolbar.default.Item, null, /*#__PURE__*/_react.default.createElement(_dropDown.ClayDropDownWithItems, {
              items: dropdownItems,
              spritemap: this.spritemap,
              trigger: /*#__PURE__*/_react.default.createElement(_button.default, {
                className: "nav-link",
                displayType: "unstyled"
              }, /*#__PURE__*/_react.default.createElement("span", {
                className: "navbar-breakpoint-down-d-none"
              }, /*#__PURE__*/_react.default.createElement("span", {
                className: "navbar-text-truncate"
              }, Liferay.Language.get('filter-and-order')), /*#__PURE__*/_react.default.createElement(_icon.default, {
                className: "inline-item inline-item-after",
                spritemap: this.spritemap,
                symbol: "caret-bottom"
              })), /*#__PURE__*/_react.default.createElement("span", {
                className: "navbar-breakpoint-d-none"
              }, /*#__PURE__*/_react.default.createElement(_icon.default, {
                spritemap: this.spritemap,
                symbol: "filter"
              })))
            })), /*#__PURE__*/_react.default.createElement(_managementToolbar.default.Item, {
              className: "lfr-portal-tooltip",
              title: Liferay.Language.get('reverse-sort-direction')
            }, /*#__PURE__*/_react.default.createElement(_button.default, {
              className: this.state.sortDirectionClass,
              displayType: "unstyled",
              onClick: function onClick() {
                return _this9._handleSortDirectionChange();
              }
            }, /*#__PURE__*/_react.default.createElement(_icon.default, {
              spritemap: this.spritemap,
              symbol: "order-arrow"
            }))), /*#__PURE__*/_react.default.createElement(_managementToolbar.default.Item, {
              className: "nav-item-expand"
            }), /*#__PURE__*/_react.default.createElement(_managementToolbar.default.Item, {
              className: "simple-toggle-switch-reverse"
            }, /*#__PURE__*/_react.default.createElement(_form.ClayToggle, {
              label: Liferay.Language.get('show-all-items'),
              onToggle: function onToggle(showHideable) {
                return _this9._handleShowHideableToggle(showHideable);
              },
              toggled: this.state.showHideable
            })), this._getViewTypes()))
          );
        }
      }, {
        key: "_renderPagination",
        value: function _renderPagination() {
          var _this10 = this;

          if (this.state.children.length <= 5) {
            return '';
          }

          return (/*#__PURE__*/_react.default.createElement(_paginationBar.ClayPaginationBarWithBasicItems, {
              activeDelta: this.state.delta,
              activePage: this.state.page,
              deltas: [4, 8, 20, 40, 60].map(function (size) {
                return {
                  label: size
                };
              }),
              ellipsisBuffer: 3,
              onDeltaChange: function onDeltaChange(delta) {
                return _this10._handleDeltaChange(delta);
              },
              onPageChange: function onPageChange(page) {
                return _this10._handlePageChange(page);
              },
              totalItems: this.state.children.length
            })
          );
        }
      }, {
        key: "_renderPanel",
        value: function _renderPanel() {
          var _this11 = this;

          if (this.state.viewType === this.VIEW_TYPE_CHANGES) {
            return '';
          }

          return (/*#__PURE__*/_react.default.createElement("div", {
              className: "col-md-3"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "panel panel-secondary"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "panel-body"
            }, /*#__PURE__*/_react.default.createElement(_form.ClayRadioGroup, {
              onSelectedValueChange: function onSelectedValueChange(filterClass) {
                return _this11._handleNavigationUpdate({
                  filterClass: filterClass,
                  nodeId: 0
                });
              },
              selectedValue: this.state.filterClass
            }, this._getRootDisplayOptions()))))
          );
        }
      }, {
        key: "_renderTable",
        value: function _renderTable() {
          if (!this.state.children || this.state.children.length === 0) {
            if (this.state.node.children && this.state.node.children.length > 0 && this.state.viewType === this.VIEW_TYPE_CHANGES) {
              return (/*#__PURE__*/_react.default.createElement("div", {
                  className: "sheet taglib-empty-result-message"
                }, /*#__PURE__*/_react.default.createElement("div", {
                  className: "taglib-empty-result-message-header"
                }), /*#__PURE__*/_react.default.createElement("div", {
                  className: "sheet-text text-center"
                }, Liferay.Language.get('there-are-no-changes-to-display-in-this-view')))
              );
            }

            return '';
          }

          return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_table.default, {
              className: "publications-table",
              headingNoWrap: true,
              hover: true,
              noWrap: true
            }, this._getTableHead(), /*#__PURE__*/_react.default.createElement(_table.default.Body, null, this._getTableRows(this._filterDisplayNodes(this.state.children)))), this._renderPagination())
          );
        }
      }, {
        key: "_updateRenderContent",
        value: function _updateRenderContent(loading, node, path) {
          var _this12 = this;

          if (!node.modelClassNameId) {
            this.setState({
              dropdownItems: null,
              loading: false,
              renderInnerHTML: null
            });
            return;
          }

          this.setState({
            loading: loading
          }, function () {
            AUI().use('liferay-portlet-url', function () {
              (0, _frontendJsWeb.fetch)(_this12._getRenderURL(node)).then(function (response) {
                return response.text();
              }).then(function (text) {
                if (!_this12._isWithinApp(new URLSearchParams(window.location.search))) {
                  return;
                }

                var dropdownItems = _this12._getDropdownItems(_this12.state.node);

                var oldState = window.history.state;

                if (oldState && oldState.modelClassNameId && oldState.modelClassNameId === node.modelClassNameId && oldState.modelClassPK === node.modelClassPK && oldState.path === path) {
                  window.history.replaceState({
                    dropdownItems: dropdownItems,
                    modelClassNameId: oldState.modelClassNameId,
                    modelClassPK: oldState.modelClassPK,
                    path: oldState.path,
                    renderInnerHTML: {
                      __html: text
                    },
                    senna: true
                  }, document.title);
                }

                if (_this12.state.node.modelClassNameId && _this12.state.node.modelClassNameId === node.modelClassNameId && _this12.state.node.modelClassPK === node.modelClassPK) {
                  _this12.setState({
                    dropdownItems: dropdownItems,
                    loading: false,
                    renderInnerHTML: {
                      __html: text
                    }
                  });
                }
              });
            });
          });
        }
      }, {
        key: "render",
        value: function render() {
          var content;

          if (this.state.viewType === this.VIEW_TYPE_CONTEXT && this.contextView.errorMessage) {
            content = /*#__PURE__*/_react.default.createElement(_alert.default, {
              displayType: "danger"
            }, this.contextView.errorMessage);
          } else {
            content = /*#__PURE__*/_react.default.createElement("div", {
              className: "container-fluid container-fluid-max-xl"
            }, /*#__PURE__*/_react.default.createElement(_breadcrumb.default, {
              ellipsisBuffer: 1,
              items: this.state.breadcrumbItems,
              spritemap: this.spritemap
            }), /*#__PURE__*/_react.default.createElement("div", {
              className: "publications-changes-content row"
            }, this._renderPanel(), /*#__PURE__*/_react.default.createElement("div", {
              className: this.state.viewType === this.VIEW_TYPE_CHANGES ? 'col-md-12' : 'col-md-9'
            }, this._renderEntry(), this._renderTable())));
          }

          return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this._renderManagementToolbar(), content)
          );
        }
      }]);

      return ChangeTrackingChangesView;
    }(_react.default.Component);

    function _default(props) {
      return (/*#__PURE__*/_react.default.createElement(ChangeTrackingChangesView, props)
      );
    }
    //# sourceMappingURL=ChangeTrackingChangesView.js.map
  }
});
//# sourceMappingURL=ChangeTrackingChangesView.js.map