Liferay.Loader.define("change-tracking-web@1.0.46/publications/js/ChangeTrackingConflictsView", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/date-picker', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/list', '@frontend-taglib-clay$clayui/modal', '@frontend-taglib-clay$clayui/pagination-bar', '@frontend-taglib-clay$clayui/panel', '@frontend-taglib-clay$clayui/time-picker', 'frontend-js-react-web$react', './ChangeTrackingBaseScheduleView'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _datePicker = _interopRequireDefault(require("@frontend-taglib-clay$clayui/date-picker"));

    var _dropDown = require("@frontend-taglib-clay$clayui/drop-down");

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _list = _interopRequireDefault(require("@frontend-taglib-clay$clayui/list"));

    var _modal = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/modal"));

    var _paginationBar = require("@frontend-taglib-clay$clayui/pagination-bar");

    var _panel = _interopRequireDefault(require("@frontend-taglib-clay$clayui/panel"));

    var _timePicker = _interopRequireDefault(require("@frontend-taglib-clay$clayui/time-picker"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ChangeTrackingBaseScheduleView = _interopRequireDefault(require("./ChangeTrackingBaseScheduleView"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var ChangeTrackingConflictsView = /*#__PURE__*/function (_ChangeTrackingBaseSc) {
      _inherits(ChangeTrackingConflictsView, _ChangeTrackingBaseSc);

      function ChangeTrackingConflictsView(props) {
        var _this;

        _classCallCheck(this, ChangeTrackingConflictsView);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(ChangeTrackingConflictsView).call(this, props));
        var publishURL = props.publishURL,
            redirect = props.redirect,
            resolvedConflicts = props.resolvedConflicts,
            schedule = props.schedule,
            scheduleURL = props.scheduleURL,
            spritemap = props.spritemap,
            timeZone = props.timeZone,
            unresolvedConflicts = props.unresolvedConflicts;
        _this.publishURL = publishURL;
        _this.redirect = redirect;
        _this.resolvedConflicts = resolvedConflicts;
        _this.schedule = schedule;
        _this.scheduleURL = scheduleURL;
        _this.spritemap = spritemap;
        _this.timeZone = timeZone;
        _this.unresolvedConflicts = unresolvedConflicts;
        _this.state = {
          date: null,
          dateError: '',
          formError: null,
          time: {
            hours: '--',
            minutes: '--'
          },
          timeError: '',
          validationError: null
        };
        return _this;
      }

      _createClass(ChangeTrackingConflictsView, [{
        key: "handleSubmit",
        value: function handleSubmit() {
          if (!this.schedule) {
            submitForm(document.hrefFm, this.publishURL);
            return;
          }

          this.doSchedule(this.scheduleURL);
        }
      }, {
        key: "render",
        value: function render() {
          var _this2 = this;

          return (/*#__PURE__*/_react.default.createElement("div", {
              className: "sheet sheet-lg"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "sheet-header"
            }, /*#__PURE__*/_react.default.createElement("h2", {
              className: "sheet-title"
            }, Liferay.Language.get('conflicting-changes')), this.unresolvedConflicts.length > 0 && /*#__PURE__*/_react.default.createElement(_alert.default, {
              displayType: "warning",
              spritemap: this.spritemap,
              title: Liferay.Language.get('this-publication-contains-conflicting-changes-that-must-be-manually-resolved-before-publishing')
            }), this.unresolvedConflicts.length == 0 && /*#__PURE__*/_react.default.createElement(_alert.default, {
              displayType: "success",
              spritemap: this.spritemap,
              title: Liferay.Language.get('no-unresolved-conflicts-ready-to-publish')
            })), /*#__PURE__*/_react.default.createElement("div", {
              className: "sheet-section"
            }, this.unresolvedConflicts.length > 0 && /*#__PURE__*/_react.default.createElement(_panel.default, {
              collapsable: true,
              defaultExpanded: true,
              displayTitle: Liferay.Language.get('needs-manual-resolution') + ' (' + this.unresolvedConflicts.length + ')',
              showCollapseIcon: true,
              spritemap: this.spritemap
            }, /*#__PURE__*/_react.default.createElement(_panel.default.Body, null, /*#__PURE__*/_react.default.createElement(ConflictsTable, {
              conflicts: this.unresolvedConflicts,
              spritemap: this.spritemap
            })))), /*#__PURE__*/_react.default.createElement("div", {
              className: "sheet-section"
            }, this.resolvedConflicts.length > 0 && /*#__PURE__*/_react.default.createElement(_panel.default, {
              collapsable: true,
              displayTitle: Liferay.Language.get('automatically-resolved') + ' (' + this.resolvedConflicts.length + ')',
              showCollapseIcon: true,
              spritemap: this.spritemap
            }, /*#__PURE__*/_react.default.createElement(_panel.default.Body, null, /*#__PURE__*/_react.default.createElement(ConflictsTable, {
              conflicts: this.resolvedConflicts,
              spritemap: this.spritemap
            })))), this.schedule && /*#__PURE__*/_react.default.createElement("div", {
              className: "sheet-section"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "sheet-subtitle"
            }, Liferay.Language.get('schedule')), /*#__PURE__*/_react.default.createElement("label", null, Liferay.Language.get('date-and-time')), /*#__PURE__*/_react.default.createElement("div", {
              className: "input-group"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: this.getDateClassName()
            }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_datePicker.default, {
              disabled: this.unresolvedConflicts.length > 0,
              onValueChange: this.handleDateChange,
              placeholder: "YYYY-MM-DD",
              spritemap: this.spritemap,
              timezone: this.timeZone,
              value: this.state.date,
              years: {
                end: new Date().getFullYear() + 1,
                start: new Date().getFullYear() - 1
              }
            }), this.getDateHelpText())), /*#__PURE__*/_react.default.createElement("div", {
              className: this.getTimeClassName()
            }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_timePicker.default, {
              disabled: this.unresolvedConflicts.length > 0,
              onInputChange: this.handleTimeChange,
              spritemap: this.spritemap,
              timezone: this.timeZone,
              values: this.state.time
            }), this.getTimeHelpText())))), this.state.formError && /*#__PURE__*/_react.default.createElement(_alert.default, {
              displayType: "danger",
              spritemap: this.spritemap,
              title: this.state.formError
            }), /*#__PURE__*/_react.default.createElement("div", {
              className: "sheet-footer sheet-footer-btn-block-sm-down"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "btn-group"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "btn-group-item"
            }, /*#__PURE__*/_react.default.createElement("button", {
              className: this.unresolvedConflicts.length > 0 ? 'btn btn-primary disabled' : 'btn btn-primary',
              onClick: function onClick() {
                return _this2.handleSubmit();
              },
              type: "button"
            }, this.schedule ? Liferay.Language.get('schedule') : Liferay.Language.get('publish'))), /*#__PURE__*/_react.default.createElement("div", {
              className: "btn-group-item"
            }, /*#__PURE__*/_react.default.createElement("button", {
              className: "btn btn-secondary",
              onClick: function onClick() {
                return Liferay.Util.navigate(_this2.redirect);
              },
              type: "button"
            }, Liferay.Language.get('cancel'))))))
          );
        }
      }]);

      return ChangeTrackingConflictsView;
    }(_ChangeTrackingBaseScheduleView.default);

    var ConflictsTable = function ConflictsTable(_ref) {
      var conflicts = _ref.conflicts,
          spritemap = _ref.spritemap;

      var _useState = (0, _react.useState)(20),
          _useState2 = _slicedToArray(_useState, 2),
          delta = _useState2[0],
          setDelta = _useState2[1];

      var _useState3 = (0, _react.useState)(1),
          _useState4 = _slicedToArray(_useState3, 2),
          page = _useState4[0],
          setPage = _useState4[1];

      var _useState5 = (0, _react.useState)(null),
          _useState6 = _slicedToArray(_useState5, 2),
          viewConflict = _useState6[0],
          setViewConflict = _useState6[1];
      /* eslint-disable no-unused-vars */

      var _useModal = (0, _modal.useModal)({
        onClose: function onClose() {
          return setViewConflict(null);
        }
      }),
          observer = _useModal.observer,
          onClose = _useModal.onClose;

      var getAlertFooter = function getAlertFooter(conflict) {
        if (!conflict.dismissURL && (!conflict.actions || conflict.actions.length === 0)) {
          return '';
        }

        var buttons = [];

        if (conflict.actions) {
          for (var i = 0; i < conflict.actions.length; i++) {
            var action = conflict.actions[i];
            buttons.push( /*#__PURE__*/_react.default.createElement("a", {
              className: "btn btn-secondary btn-sm",
              href: action.href
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "inline-item inline-item-before"
            }, /*#__PURE__*/_react.default.createElement(_icon.default, {
              spritemap: spritemap,
              symbol: action.symbol
            })), action.label));
          }
        }

        if (conflict.dismissURL) {
          buttons.push( /*#__PURE__*/_react.default.createElement("a", {
            className: "btn btn-secondary btn-sm",
            href: conflict.dismissURL
          }, Liferay.Language.get('dismiss')));
        }

        return (/*#__PURE__*/_react.default.createElement(_alert.default.Footer, null, /*#__PURE__*/_react.default.createElement("div", {
            className: "btn-group-sm",
            role: "group"
          }, buttons))
        );
      };

      var getDismissAction = function getDismissAction(conflict) {
        if (!conflict.dismissURL) {
          return '';
        }

        return (/*#__PURE__*/_react.default.createElement(_list.default.ItemField, null, /*#__PURE__*/_react.default.createElement("a", {
            className: "btn btn-secondary btn-sm",
            href: conflict.dismissURL
          }, Liferay.Language.get('dismiss')))
        );
      };

      var getDropdownMenu = function getDropdownMenu(conflict) {
        if (!conflict.actions) {
          return '';
        }

        var items = [];

        for (var i = 0; i < conflict.actions.length; i++) {
          var action = conflict.actions[i];
          items.push({
            href: action.href,
            label: action.label,
            symbolLeft: action.symbol
          });
        }

        return (/*#__PURE__*/_react.default.createElement(_list.default.ItemField, null, /*#__PURE__*/_react.default.createElement(_dropDown.ClayDropDownWithItems, {
            alignmentPosition: _dropDown.Align.BottomLeft,
            items: items,
            spritemap: spritemap,
            trigger: /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
              displayType: "unstyled",
              small: true,
              spritemap: spritemap,
              symbol: "ellipsis-v"
            })
          }))
        );
      };

      var getQuickActionMenu = function getQuickActionMenu(conflict) {
        if (!conflict.actions) {
          return '';
        }

        var items = [];

        for (var i = 0; i < conflict.actions.length; i++) {
          var action = conflict.actions[i];
          items.push( /*#__PURE__*/_react.default.createElement(_list.default.QuickActionMenu.Item, {
            className: "lfr-portal-tooltip",
            href: action.href,
            spritemap: spritemap,
            symbol: action.symbol,
            title: action.label
          }));
        }

        return (/*#__PURE__*/_react.default.createElement(_list.default.ItemField, null, /*#__PURE__*/_react.default.createElement(_list.default.QuickActionMenu, null, items))
        );
      };

      var handleDeltaChange = function handleDeltaChange(delta) {
        setDelta(delta);
        setPage(1);
      };

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, function renderViewModal() {
          if (!viewConflict) {
            return '';
          }

          return (/*#__PURE__*/_react.default.createElement(_modal.default, {
              className: "publications-modal",
              observer: observer,
              size: "full-screen",
              spritemap: spritemap
            }, /*#__PURE__*/_react.default.createElement(_modal.default.Header, null, /*#__PURE__*/_react.default.createElement("div", {
              className: "autofit-row"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "autofit-col"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "modal-title"
            }, viewConflict.title), /*#__PURE__*/_react.default.createElement("div", {
              className: "modal-description"
            }, viewConflict.description)))), /*#__PURE__*/_react.default.createElement(_modal.default.Header, {
              className: "publications-conflicts-header",
              withTitle: false
            }, /*#__PURE__*/_react.default.createElement(_alert.default, {
              displayType: viewConflict.alertType,
              spritemap: spritemap,
              title: viewConflict.conflictDescription + ':'
            }, viewConflict.conflictResolution, getAlertFooter(viewConflict))), /*#__PURE__*/_react.default.createElement(_modal.default.Body, {
              url: viewConflict.viewURL
            }))
          );
        }(), /*#__PURE__*/_react.default.createElement(_list.default, {
          showQuickActionsOnHover: true
        }, function getListItems() {
          var items = [];
          var filteredConflicts = conflicts.slice(0);

          if (filteredConflicts.length > 5) {
            filteredConflicts = filteredConflicts.slice(delta * (page - 1), delta * page);
          }

          var _loop = function _loop(i) {
            var conflict = filteredConflicts[i];
            items.push( /*#__PURE__*/_react.default.createElement(_list.default.Item, {
              flex: true
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemField, {
              expand: true
            }, /*#__PURE__*/_react.default.createElement("a", {
              onClick: function onClick() {
                return setViewConflict(conflict);
              }
            }, /*#__PURE__*/_react.default.createElement(_list.default.ItemText, {
              className: "conflicts-description-text",
              subtext: true
            }, conflict.description), /*#__PURE__*/_react.default.createElement(_list.default.ItemTitle, null, conflict.title), /*#__PURE__*/_react.default.createElement(_list.default.ItemText, {
              className: 'conflicts-' + conflict.alertType + '-text'
            }, /*#__PURE__*/_react.default.createElement("strong", null, conflict.conflictDescription + ': '), conflict.conflictResolution))), getDismissAction(conflict), getQuickActionMenu(conflict), getDropdownMenu(conflict)));
          };

          for (var i = 0; i < filteredConflicts.length; i++) {
            _loop(i);
          }

          return items;
        }()), function renderPagination() {
          if (conflicts.length <= 5) {
            return '';
          }

          return (/*#__PURE__*/_react.default.createElement(_paginationBar.ClayPaginationBarWithBasicItems, {
              activeDelta: delta,
              activePage: page,
              deltas: [4, 8, 20, 40, 60].map(function (size) {
                return {
                  label: size
                };
              }),
              ellipsisBuffer: 3,
              onDeltaChange: function onDeltaChange(delta) {
                return handleDeltaChange(delta);
              },
              onPageChange: function onPageChange(page) {
                return setPage(page);
              },
              totalItems: conflicts.length
            })
          );
        }())
      );
    };

    function _default(props) {
      return (/*#__PURE__*/_react.default.createElement(ChangeTrackingConflictsView, props)
      );
    }
    //# sourceMappingURL=ChangeTrackingConflictsView.js.map
  }
});
//# sourceMappingURL=ChangeTrackingConflictsView.js.map