Liferay.Loader.define("change-tracking-web@1.0.46/publications/js/ChangeTrackingDiscardView", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/modal', '@frontend-taglib-clay$clayui/pagination-bar', '@frontend-taglib-clay$clayui/table', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _modal = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/modal"));

    var _paginationBar = require("@frontend-taglib-clay$clayui/pagination-bar");

    var _table = _interopRequireDefault(require("@frontend-taglib-clay$clayui/table"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var ChangeTrackingDiscardView = function ChangeTrackingDiscardView(_ref) {
      var ctEntriesJSONArray = _ref.ctEntriesJSONArray,
          spritemap = _ref.spritemap,
          typeNames = _ref.typeNames,
          userInfo = _ref.userInfo;

      var _useState = (0, _react.useState)(20),
          _useState2 = _slicedToArray(_useState, 2),
          delta = _useState2[0],
          setDelta = _useState2[1];

      var _useState3 = (0, _react.useState)(1),
          _useState4 = _slicedToArray(_useState3, 2),
          page = _useState4[0],
          setPage = _useState4[1];

      var _useState5 = (0, _react.useState)(null),
          _useState6 = _slicedToArray(_useState5, 2),
          viewEntry = _useState6[0],
          setViewEntry = _useState6[1];
      /* eslint-disable no-unused-vars */

      var _useModal = (0, _modal.useModal)({
        onClose: function onClose() {
          return setViewEntry(null);
        }
      }),
          observer = _useModal.observer,
          onClose = _useModal.onClose;

      var ctEntries = ctEntriesJSONArray.slice(0);

      for (var i = 0; i < ctEntries.length; i++) {
        var entry = ctEntries[i];
        var entryUserInfo = userInfo[entry.userId.toString()];
        entry.portraitURL = entryUserInfo.portraitURL;
        entry.userName = entryUserInfo.userName;
        entry.typeName = typeNames[entry.modelClassNameId.toString()];
      }

      ctEntries.sort(function (a, b) {
        var titleA = a.title;
        var titleB = b.title;
        var typeNameA = a.typeName.toUpperCase();
        var typeNameB = b.typeName.toUpperCase();

        if (typeNameA < typeNameB) {
          return -1;
        }

        if (typeNameA > typeNameB) {
          return 1;
        }

        if (titleA < titleB) {
          return -1;
        }

        if (titleA > titleB) {
          return 1;
        }

        return 0;
      });

      var filterDisplayEntries = function filterDisplayEntries(entries) {
        if (entries.length > 5) {
          entries = entries.slice(delta * (page - 1), delta * page);
        }

        return entries;
      };

      var getUserPortrait = function getUserPortrait(entry) {
        if (entry.portraitURL) {
          return (/*#__PURE__*/_react.default.createElement("span", {
              className: "lfr-portal-tooltip",
              title: entry.userName
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "rounded-circle sticker sticker-primary"
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "sticker-overlay"
            }, /*#__PURE__*/_react.default.createElement("img", {
              alt: "thumbnail",
              className: "img-fluid",
              src: entry.portraitURL
            }))))
          );
        }

        var userPortraitCss = 'sticker sticker-circle sticker-light user-icon-color-';
        userPortraitCss += entry.userId % 10;
        return (/*#__PURE__*/_react.default.createElement("span", {
            className: "lfr-portal-tooltip",
            title: entry.userName
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: userPortraitCss
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "inline-item"
          }, /*#__PURE__*/_react.default.createElement("svg", {
            className: "lexicon-icon"
          }, /*#__PURE__*/_react.default.createElement("use", {
            href: spritemap + '#user'
          })))))
        );
      };

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, function renderViewModal() {
          if (!viewEntry) {
            return '';
          }

          return (/*#__PURE__*/_react.default.createElement(_modal.default, {
              className: "publications-modal",
              observer: observer,
              size: "full-screen",
              spritemap: spritemap
            }, /*#__PURE__*/_react.default.createElement(_modal.default.Header, null, /*#__PURE__*/_react.default.createElement("div", {
              className: "autofit-row"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "autofit-col publications-discard-user-portrait"
            }, getUserPortrait(viewEntry)), /*#__PURE__*/_react.default.createElement("div", {
              className: "autofit-col"
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "modal-title"
            }, viewEntry.title), /*#__PURE__*/_react.default.createElement("div", {
              className: "modal-description"
            }, viewEntry.description)))), /*#__PURE__*/_react.default.createElement(_modal.default.Body, {
              url: viewEntry.viewURL
            }))
          );
        }(), /*#__PURE__*/_react.default.createElement(_table.default, {
          className: "publications-table",
          hover: true
        }, /*#__PURE__*/_react.default.createElement(_table.default.Head, null, /*#__PURE__*/_react.default.createElement(_table.default.Row, null, /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
          headingCell: true,
          style: {
            width: '5%'
          }
        }, Liferay.Language.get('user')), /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
          headingCell: true,
          style: {
            width: '95%'
          }
        }, Liferay.Language.get('change')))), /*#__PURE__*/_react.default.createElement(_table.default.Body, null, function getTableRows() {
          var rows = [];
          var currentTypeName = '';
          var entries = filterDisplayEntries(ctEntries);

          var _loop = function _loop(_i2) {
            var entry = entries[_i2];

            if (entry.typeName !== currentTypeName) {
              currentTypeName = entry.typeName;
              rows.push( /*#__PURE__*/_react.default.createElement(_table.default.Row, {
                divider: true
              }, /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
                colSpan: 2
              }, entry.typeName)));
            }

            rows.push( /*#__PURE__*/_react.default.createElement(_table.default.Row, {
              className: "cursor-pointer",
              onClick: function onClick() {
                return setViewEntry(entry);
              }
            }, /*#__PURE__*/_react.default.createElement(_table.default.Cell, null, getUserPortrait(entry)), /*#__PURE__*/_react.default.createElement(_table.default.Cell, null, /*#__PURE__*/_react.default.createElement("div", {
              className: "publication-name"
            }, entry.title), /*#__PURE__*/_react.default.createElement("div", {
              className: "publication-description"
            }, entry.description))));
          };

          for (var _i2 = 0; _i2 < entries.length; _i2++) {
            _loop(_i2);
          }

          return rows;
        }())), function renderPagination() {
          if (ctEntries.length <= 5) {
            return '';
          }

          return (/*#__PURE__*/_react.default.createElement(_paginationBar.ClayPaginationBarWithBasicItems, {
              activeDelta: delta,
              activePage: page,
              deltas: [4, 8, 20, 40, 60].map(function (size) {
                return {
                  label: size
                };
              }),
              ellipsisBuffer: 3,
              onDeltaChange: function onDeltaChange(newDelta) {
                setDelta(newDelta);
                setPage(1);
              },
              onPageChange: function onPageChange(newPage) {
                return setPage(newPage);
              },
              totalItems: ctEntries.length
            })
          );
        }())
      );
    };

    function _default(props) {
      return (/*#__PURE__*/_react.default.createElement(ChangeTrackingDiscardView, props)
      );
    }
    //# sourceMappingURL=ChangeTrackingDiscardView.js.map
  }
});
//# sourceMappingURL=ChangeTrackingDiscardView.js.map