Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/_lib/setUTCISODay/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toInteger from '../toInteger/index.js';
    import toDate from '../../toDate/index.js';
    import requiredArgs from '../requiredArgs/index.js'; // This function will be a part of public API when UTC function will be implemented.
    // See issue: https://github.com/date-fns/date-fns/issues/376

    export default function setUTCISODay(dirtyDate, dirtyDay) {
      requiredArgs(2, arguments);
      var day = toInteger(dirtyDay);

      if (day % 7 === 0) {
        day = day - 7;
      }

      var date = toDate(dirtyDate);
      var currentDay = date.getUTCDay();
      var remainder = day % 7;

      var diff = ((remainder + 7) % 7 < 1 ? 7 : 0) + day - currentDay;
      date.setUTCDate(date.getUTCDate() + diff);
      return date;
    }
  }
});
//# sourceMappingURL=index.js.map