Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/addQuarters/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toInteger from '../_lib/toInteger/index.js';
    import addMonths from '../addMonths/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name addQuarters
     * @category Quarter Helpers
     * @summary Add the specified number of year quarters to the given date.
     *
     * @description
     * Add the specified number of year quarters to the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to be changed
     * @param {Number} amount - the amount of quarters to be added. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
     * @returns {Date} the new date with the quarters added
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Add 1 quarter to 1 September 2014:
     * var result = addQuarters(new Date(2014, 8, 1), 1)
     * //=> Mon Dec 01 2014 00:00:00
     */

    export default function addQuarters(dirtyDate, dirtyAmount) {
      requiredArgs(2, arguments);
      var amount = toInteger(dirtyAmount);

      return addMonths(dirtyDate, amount * 3);
    }
  }
});
//# sourceMappingURL=index.js.map