Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/differenceInCalendarWeeks/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import startOfWeek from '../startOfWeek/index.js';
    import getTimezoneOffsetInMilliseconds from '../_lib/getTimezoneOffsetInMilliseconds/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    var MILLISECONDS_IN_WEEK = 604800000;
    /**
     * @name differenceInCalendarWeeks
     * @category Week Helpers
     * @summary Get the number of calendar weeks between the given dates.
     *
     * @description
     * Get the number of calendar weeks between the given dates.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} dateLeft - the later date
     * @param {Date|Number} dateRight - the earlier date
     * @param {Object} [options] - an object with options.
     * @param {Locale} [options.locale=defaultLocale] - the locale object. See [Locale]{@link https://date-fns.org/docs/Locale}
     * @param {0|1|2|3|4|5|6} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
     * @returns {Number} the number of calendar weeks
     * @throws {TypeError} 2 arguments required
     * @throws {RangeError} `options.weekStartsOn` must be between 0 and 6
     *
     * @example
     * // How many calendar weeks are between 5 July 2014 and 20 July 2014?
     * var result = differenceInCalendarWeeks(
     *   new Date(2014, 6, 20),
     *   new Date(2014, 6, 5)
     * )
     * //=> 3
     *
     * @example
     * // If the week starts on Monday,
     * // how many calendar weeks are between 5 July 2014 and 20 July 2014?
     * var result = differenceInCalendarWeeks(
     *   new Date(2014, 6, 20),
     *   new Date(2014, 6, 5),
     *   { weekStartsOn: 1 }
     * )
     * //=> 2
     */

    export default function differenceInCalendarWeeks(dirtyDateLeft, dirtyDateRight, dirtyOptions) {
      requiredArgs(2, arguments);
      var startOfWeekLeft = startOfWeek(dirtyDateLeft, dirtyOptions);
      var startOfWeekRight = startOfWeek(dirtyDateRight, dirtyOptions);
      var timestampLeft = startOfWeekLeft.getTime() - getTimezoneOffsetInMilliseconds(startOfWeekLeft);
      var timestampRight = startOfWeekRight.getTime() - getTimezoneOffsetInMilliseconds(startOfWeekRight); // Round the number of days to the nearest integer
      // because the number of milliseconds in a week is not constant
      // (e.g. it's different in the week of the daylight saving time clock shift)

      return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_WEEK);
    }
  }
});
//# sourceMappingURL=index.js.map