Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/differenceInYears/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toDate from '../toDate/index.js';
    import differenceInCalendarYears from '../differenceInCalendarYears/index.js';
    import compareAsc from '../compareAsc/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name differenceInYears
     * @category Year Helpers
     * @summary Get the number of full years between the given dates.
     *
     * @description
     * Get the number of full years between the given dates.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} dateLeft - the later date
     * @param {Date|Number} dateRight - the earlier date
     * @returns {Number} the number of full years
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // How many full years are between 31 December 2013 and 11 February 2015?
     * var result = differenceInYears(new Date(2015, 1, 11), new Date(2013, 11, 31))
     * //=> 1
     */

    export default function differenceInYears(dirtyDateLeft, dirtyDateRight) {
      requiredArgs(2, arguments);
      var dateLeft = toDate(dirtyDateLeft);
      var dateRight = toDate(dirtyDateRight);
      var sign = compareAsc(dateLeft, dateRight);
      var difference = Math.abs(differenceInCalendarYears(dateLeft, dateRight)); // Set both dates to a valid leap year for accurate comparison when dealing
      // with leap days

      dateLeft.setFullYear('1584');
      dateRight.setFullYear('1584'); // Math.abs(diff in full years - diff in calendar years) === 1 if last calendar year is not full
      // If so, result must be decreased by 1 in absolute value

      var isLastYearNotFull = compareAsc(dateLeft, dateRight) === -sign;
      var result = sign * (difference - isLastYearNotFull); // Prevent negative zero

      return result === 0 ? 0 : result;
    }
  }
});
//# sourceMappingURL=index.js.map