Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/endOfSecond/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toDate from '../toDate/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name endOfSecond
     * @category Second Helpers
     * @summary Return the end of a second for the given date.
     *
     * @description
     * Return the end of a second for the given date.
     * The result will be in the local timezone.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the original date
     * @returns {Date} the end of a second
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // The end of a second for 1 December 2014 22:15:45.400:
     * var result = endOfSecond(new Date(2014, 11, 1, 22, 15, 45, 400))
     * //=> Mon Dec 01 2014 22:15:45.999
     */

    export default function endOfSecond(dirtyDate) {
      requiredArgs(1, arguments);
      var date = toDate(dirtyDate);
      date.setMilliseconds(999);
      return date;
    }
  }
});
//# sourceMappingURL=index.js.map