Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/getISOWeek/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toDate from '../toDate/index.js';
    import startOfISOWeek from '../startOfISOWeek/index.js';
    import startOfISOWeekYear from '../startOfISOWeekYear/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    var MILLISECONDS_IN_WEEK = 604800000;
    /**
     * @name getISOWeek
     * @category ISO Week Helpers
     * @summary Get the ISO week of the given date.
     *
     * @description
     * Get the ISO week of the given date.
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the given date
     * @returns {Number} the ISO week
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Which week of the ISO-week numbering year is 2 January 2005?
     * var result = getISOWeek(new Date(2005, 0, 2))
     * //=> 53
     */

    export default function getISOWeek(dirtyDate) {
      requiredArgs(1, arguments);
      var date = toDate(dirtyDate);
      var diff = startOfISOWeek(date).getTime() - startOfISOWeekYear(date).getTime(); // Round the number of days to the nearest integer
      // because the number of milliseconds in a week is not constant
      // (e.g. it's different in the week of the daylight saving time clock shift)

      return Math.round(diff / MILLISECONDS_IN_WEEK) + 1;
    }
  }
});
//# sourceMappingURL=index.js.map