Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/getQuarter/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toDate from '../toDate/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name getQuarter
     * @category Quarter Helpers
     * @summary Get the year quarter of the given date.
     *
     * @description
     * Get the year quarter of the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the given date
     * @returns {Number} the quarter
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Which quarter is 2 July 2014?
     * var result = getQuarter(new Date(2014, 6, 2))
     * //=> 3
     */

    export default function getQuarter(dirtyDate) {
      requiredArgs(1, arguments);
      var date = toDate(dirtyDate);
      var quarter = Math.floor(date.getMonth() / 3) + 1;
      return quarter;
    }
  }
});
//# sourceMappingURL=index.js.map