Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/isSameISOWeek/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import isSameWeek from '../isSameWeek/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name isSameISOWeek
     * @category ISO Week Helpers
     * @summary Are the given dates in the same ISO week?
     *
     * @description
     * Are the given dates in the same ISO week?
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} dateLeft - the first date to check
     * @param {Date|Number} dateRight - the second date to check
     * @returns {Boolean} the dates are in the same ISO week
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Are 1 September 2014 and 7 September 2014 in the same ISO week?
     * var result = isSameISOWeek(new Date(2014, 8, 1), new Date(2014, 8, 7))
     * //=> true
     */

    export default function isSameISOWeek(dirtyDateLeft, dirtyDateRight) {
      requiredArgs(2, arguments);
      return isSameWeek(dirtyDateLeft, dirtyDateRight, {
        weekStartsOn: 1
      });
    }
  }
});
//# sourceMappingURL=index.js.map