Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/isSunday/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toDate from '../toDate/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name isSunday
     * @category Weekday Helpers
     * @summary Is the given date Sunday?
     *
     * @description
     * Is the given date Sunday?
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @returns {Boolean} the date is Sunday
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Is 21 September 2014 Sunday?
     * var result = isSunday(new Date(2014, 8, 21))
     * //=> true
     */

    export default function isSunday(dirtyDate) {
      requiredArgs(1, arguments);
      return toDate(dirtyDate).getDay() === 0;
    }
  }
});
//# sourceMappingURL=index.js.map