Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/isToday/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import isSameDay from '../isSameDay/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name isToday
     * @category Day Helpers
     * @summary Is the given date today?
     * @pure false
     *
     * @description
     * Is the given date today?
     *
     * > ⚠️ Please note that this function is not present in the FP submodule as
     * > it uses `Date.now()` internally hence impure and can't be safely curried.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @returns {Boolean} the date is today
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // If today is 6 October 2014, is 6 October 14:00:00 today?
     * var result = isToday(new Date(2014, 9, 6, 14, 0))
     * //=> true
     */

    export default function isToday(dirtyDate) {
      requiredArgs(1, arguments);
      return isSameDay(dirtyDate, Date.now());
    }
  }
});
//# sourceMappingURL=index.js.map