Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/locale/ar-MA/_lib/localize/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import buildLocalizeFn from '../../../_lib/buildLocalizeFn/index.js';
    var eraValues = {
      narrow: ['ق', 'ب'],
      abbreviated: ['ق.م.', 'ب.م.'],
      wide: ['قبل الميلاد', 'بعد الميلاد']
    };
    var quarterValues = {
      narrow: ['1', '2', '3', '4'],
      abbreviated: ['ر1', 'ر2', 'ر3', 'ر4'],
      wide: ['الربع الأول', 'الربع الثاني', 'الربع الثالث', 'الربع الرابع']
    };
    var monthValues = {
      narrow: ['ي', 'ف', 'م', 'أ', 'م', 'ي', 'ي', 'غ', 'ش', 'أ', 'ن', 'د'],
      abbreviated: ['ينا', 'فبر', 'مارس', 'أبريل', 'ماي', 'يونـ', 'يولـ', 'غشت', 'شتنـ', 'أكتـ', 'نونـ', 'دجنـ'],
      wide: ['يناير', 'فبراير', 'مارس', 'أبريل', 'ماي', 'يونيو', 'يوليوز', 'غشت', 'شتنبر', 'أكتوبر', 'نونبر', 'دجنبر']
    };
    var dayValues = {
      narrow: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
      short: ['أحد', 'اثنين', 'ثلاثاء', 'أربعاء', 'خميس', 'جمعة', 'سبت'],
      abbreviated: ['أحد', 'اثنـ', 'ثلا', 'أربـ', 'خميـ', 'جمعة', 'سبت'],
      wide: ['الأحد', 'الإثنين', 'الثلاثاء', 'الأربعاء', 'الخميس', 'الجمعة', 'السبت']
    };
    var dayPeriodValues = {
      narrow: {
        am: 'ص',
        pm: 'م',
        midnight: 'ن',
        noon: 'ظ',
        morning: 'صباحاً',
        afternoon: 'بعد الظهر',
        evening: 'مساءاً',
        night: 'ليلاً'
      },
      abbreviated: {
        am: 'ص',
        pm: 'م',
        midnight: 'نصف الليل',
        noon: 'ظهر',
        morning: 'صباحاً',
        afternoon: 'بعد الظهر',
        evening: 'مساءاً',
        night: 'ليلاً'
      },
      wide: {
        am: 'ص',
        pm: 'م',
        midnight: 'نصف الليل',
        noon: 'ظهر',
        morning: 'صباحاً',
        afternoon: 'بعد الظهر',
        evening: 'مساءاً',
        night: 'ليلاً'
      }
    };
    var formattingDayPeriodValues = {
      narrow: {
        am: 'ص',
        pm: 'م',
        midnight: 'ن',
        noon: 'ظ',
        morning: 'في الصباح',
        afternoon: 'بعد الظـهر',
        evening: 'في المساء',
        night: 'في الليل'
      },
      abbreviated: {
        am: 'ص',
        pm: 'م',
        midnight: 'نصف الليل',
        noon: 'ظهر',
        morning: 'في الصباح',
        evening: 'في المساء',
        night: 'في الليل'
      },
      wide: {
        am: 'ص',
        pm: 'م',
        midnight: 'نصف الليل',
        noon: 'ظهر',
        afternoon: 'بعد الظـهر',
        evening: 'في المساء',
        night: 'في الليل'
      }
    };

    function ordinalNumber(dirtyNumber) {
      return String(dirtyNumber);
    }

    var localize = {
      ordinalNumber: ordinalNumber,
      era: buildLocalizeFn({
        values: eraValues,
        defaultWidth: 'wide'
      }),
      quarter: buildLocalizeFn({
        values: quarterValues,
        defaultWidth: 'wide',
        argumentCallback: function (quarter) {
          return Number(quarter) - 1;
        }
      }),
      month: buildLocalizeFn({
        values: monthValues,
        defaultWidth: 'wide'
      }),
      day: buildLocalizeFn({
        values: dayValues,
        defaultWidth: 'wide'
      }),
      dayPeriod: buildLocalizeFn({
        values: dayPeriodValues,
        defaultWidth: 'wide',
        formattingValues: formattingDayPeriodValues,
        defaultFormattingWidth: 'wide'
      })
    };
    export default localize;
  }
});
//# sourceMappingURL=index.js.map