Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/locale/fil/_lib/match/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import buildMatchFn from '../../../_lib/buildMatchFn/index.js';
    import buildParseFn from '../../../_lib/buildParseFn/index.js';
    import buildMatchPatternFn from '../../../_lib/buildMatchPatternFn/index.js';
    import parseDecimal from '../../../_lib/parseDecimal/index.js';
    var matchOrdinalNumbersPattern = /^(\d+)(th|st|nd|rd)?/i;
    var matchWeekdaysPatterns = {
      narrow: /^(su|mo|tu|we|th|fr|sa)/i,
      short: /^(sun|mon|tue|wed|thu|fri|sat)/i,
      long: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
    };
    var parseWeekdayPatterns = {
      any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
    };
    var matchMonthsPatterns = {
      short: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
      long: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
    };
    var parseMonthPatterns = {
      any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
    };
    var matchTimesOfDayPatterns = {
      short: /^(am|pm)/i,
      long: /^([ap]\.?\s?m\.?)/i
    };
    var parseTimeOfDayPatterns = {
      any: [/^a/i, /^p/i]
    };
    var match = {
      ordinalNumbers: buildMatchPatternFn(matchOrdinalNumbersPattern),
      ordinalNumber: parseDecimal,
      weekdays: buildMatchFn(matchWeekdaysPatterns, 'long'),
      weekday: buildParseFn(parseWeekdayPatterns, 'any'),
      months: buildMatchFn(matchMonthsPatterns, 'long'),
      month: buildParseFn(parseMonthPatterns, 'any'),
      timesOfDay: buildMatchFn(matchTimesOfDayPatterns, 'long'),
      timeOfDay: buildParseFn(parseTimeOfDayPatterns, 'any')
    };
    export default match;
  }
});
//# sourceMappingURL=index.js.map