Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/locale/tr/_lib/localize/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import buildLocalizeFn from '../../../_lib/buildLocalizeFn/index.js';
    var eraValues = {
      abbreviated: ['MÖ', 'MS'],
      narrow: ['MÖ', 'MS'],
      wide: ['Milattan Önce', 'Milattan Sonra']
    };
    var quarterValues = {
      narrow: ['1', '2', '3', '4'],
      abbreviated: ['1Ç', '2Ç', '3Ç', '4Ç'],
      wide: ['İlk çeyrek', 'İkinci Çeyrek', 'Üçüncü çeyrek', 'Son çeyrek']
    };
    var monthValues = {
      narrow: ['O', 'Ş', 'M', 'N', 'M', 'H', 'T', 'A', 'E', 'E', 'K', 'A'],
      abbreviated: ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara'],
      wide: ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz', 'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık']
    };
    var dayValues = {
      narrow: ['P', 'P', 'S', 'Ç', 'P', 'C', 'C'],
      short: ['Pz', 'Pt', 'Sa', 'Ça', 'Pe', 'Cu', 'Ct'],
      abbreviated: ['Paz', 'Pts', 'Sal', 'Çar', 'Per', 'Cum', 'Cts'],
      wide: ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi']
    };
    var dayPeriodValues = {
      narrow: {
        am: 'öö',
        pm: 'ös',
        midnight: 'gy',
        noon: 'ö',
        morning: 'sa',
        afternoon: 'ös',
        evening: 'ak',
        night: 'ge'
      },
      abbreviated: {
        am: 'ÖÖ',
        pm: 'ÖS',
        midnight: 'gece yarısı',
        noon: 'öğle',
        morning: 'sabah',
        afternoon: 'öğleden sonra',
        evening: 'akşam',
        night: 'gece'
      },
      wide: {
        am: 'Ö.Ö.',
        pm: 'Ö.S.',
        midnight: 'gece yarısı',
        noon: 'öğle',
        morning: 'sabah',
        afternoon: 'öğleden sonra',
        evening: 'akşam',
        night: 'gece'
      }
    };
    var formattingDayPeriodValues = {
      narrow: {
        am: 'öö',
        pm: 'ös',
        midnight: 'gy',
        noon: 'ö',
        morning: 'sa',
        afternoon: 'ös',
        evening: 'ak',
        night: 'ge'
      },
      abbreviated: {
        am: 'ÖÖ',
        pm: 'ÖS',
        midnight: 'gece yarısı',
        noon: 'öğlen',
        morning: 'sabahleyin',
        afternoon: 'öğleden sonra',
        evening: 'akşamleyin',
        night: 'geceleyin'
      },
      wide: {
        am: 'ö.ö.',
        pm: 'ö.s.',
        midnight: 'gece yarısı',
        noon: 'öğlen',
        morning: 'sabahleyin',
        afternoon: 'öğleden sonra',
        evening: 'akşamleyin',
        night: 'geceleyin'
      }
    };

    function ordinalNumber(dirtyNumber, _dirtyOptions) {
      var number = Number(dirtyNumber);
      return number + '.';
    }

    var localize = {
      ordinalNumber: ordinalNumber,
      era: buildLocalizeFn({
        values: eraValues,
        defaultWidth: 'wide'
      }),
      quarter: buildLocalizeFn({
        values: quarterValues,
        defaultWidth: 'wide',
        argumentCallback: function (quarter) {
          return Number(quarter) - 1;
        }
      }),
      month: buildLocalizeFn({
        values: monthValues,
        defaultWidth: 'wide'
      }),
      day: buildLocalizeFn({
        values: dayValues,
        defaultWidth: 'wide'
      }),
      dayPeriod: buildLocalizeFn({
        values: dayPeriodValues,
        defaultWidth: 'wide',
        formattingValues: formattingDayPeriodValues,
        defaulFormattingWidth: 'wide'
      })
    };
    export default localize;
  }
});
//# sourceMappingURL=index.js.map