Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/startOfQuarter/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toDate from '../toDate/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name startOfQuarter
     * @category Quarter Helpers
     * @summary Return the start of a year quarter for the given date.
     *
     * @description
     * Return the start of a year quarter for the given date.
     * The result will be in the local timezone.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the original date
     * @returns {Date} the start of a quarter
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // The start of a quarter for 2 September 2014 11:55:00:
     * var result = startOfQuarter(new Date(2014, 8, 2, 11, 55, 0))
     * //=> Tue Jul 01 2014 00:00:00
     */

    export default function startOfQuarter(dirtyDate) {
      requiredArgs(1, arguments);
      var date = toDate(dirtyDate);
      var currentMonth = date.getMonth();

      date.setMonth(currentMonth - currentMonth % 3, 1);
      date.setHours(0, 0, 0, 0);
      return date;
    }
  }
});
//# sourceMappingURL=index.js.map