/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.sanitizer.internal;

import com.liferay.comment.sanitizer.internal.CommentAllowedContent;
import com.liferay.portal.kernel.sanitizer.Sanitizer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

@Component(immediate=true, service={Sanitizer.class})
public class CommentSanitizerImpl
implements Sanitizer {
    private final CommentAllowedContent _commentAllowedContent = new CommentAllowedContent(PropsValues.DISCUSSION_COMMENTS_ALLOWED_CONTENT);

    public String sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, String content, Map<String, Object> options) {
        if (MapUtil.isEmpty(options)) {
            return content;
        }
        boolean discussion = GetterUtil.getBoolean((Object)options.get("discussion"));
        if (!discussion || !contentType.equals("text/html")) {
            return content;
        }
        return this.sanitize(content);
    }

    protected String sanitize(String html) {
        HtmlPolicyBuilder htmlPolicyBuilder = new HtmlPolicyBuilder();
        htmlPolicyBuilder.allowStandardUrlProtocols();
        Map<String, String[]> attributeNames = this._commentAllowedContent.getAttributeNames();
        for (Map.Entry<String, String[]> entry : attributeNames.entrySet()) {
            String elementName = entry.getKey();
            String[] attributesNames = entry.getValue();
            if (attributesNames != null) {
                HtmlPolicyBuilder.AttributeBuilder attributeBuilder = htmlPolicyBuilder.allowAttributes(attributesNames);
                attributeBuilder.onElements(new String[]{elementName});
            }
            htmlPolicyBuilder.allowElements(new String[]{elementName});
        }
        PolicyFactory policyFactory = htmlPolicyBuilder.toFactory();
        return policyFactory.sanitize(html);
    }
}

