/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.internal.upgrade.v2_0_0;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class EntryUpgradeProcess
extends UpgradeProcess {
    private final UserLocalService _userLocalService;

    public EntryUpgradeProcess(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.updateEntries();
    }

    protected void updateEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId, emailAddress, entryId from Contacts_Entry");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String emailAddress;
                long companyId = resultSet.getLong("companyId");
                User user = this._userLocalService.fetchUserByEmailAddress(companyId, emailAddress = resultSet.getString("emailAddress"));
                if (user == null) continue;
                long entryId = resultSet.getLong("entryId");
                this.runSQL("delete from Contacts_Entry where entryId = " + entryId);
            }
        }
    }
}

