/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.service.impl;

import com.liferay.contacts.exception.DuplicateEntryEmailAddressException;
import com.liferay.contacts.exception.EntryEmailAddressException;
import com.liferay.contacts.exception.RequiredEntryEmailAddressException;
import com.liferay.contacts.model.Entry;
import com.liferay.contacts.service.base.EntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.ContactNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.FullNameValidatorFactory;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.contacts.model.Entry"}, service={AopService.class})
public class EntryLocalServiceImpl
extends EntryLocalServiceBaseImpl {
    public Entry addEntry(long userId, String fullName, String emailAddress, String comments) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        this.validate(user.getCompanyId(), 0L, userId, fullName, emailAddress);
        long contactId = this.counterLocalService.increment();
        Entry entry = this.entryPersistence.create(contactId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setCreateDate(date);
        entry.setModifiedDate(date);
        entry.setFullName(fullName);
        entry.setEmailAddress(emailAddress);
        entry.setComments(comments);
        return (Entry)this.entryPersistence.update((BaseModel)entry);
    }

    public List<Entry> getEntries(long userId, int start, int end) {
        return this.entryPersistence.findByUserId(userId);
    }

    public int getEntriesCount(long userId) {
        return this.entryPersistence.countByUserId(userId);
    }

    public List<Entry> search(long userId, String keywords, int start, int end) {
        return this.entryFinder.findByKeywords(userId, keywords, start, end);
    }

    public int searchCount(long userId, String keywords) {
        return this.entryFinder.countByKeywords(userId, keywords);
    }

    public List<BaseModel<?>> searchUsersAndContacts(long companyId, long userId, String keywords, int start, int end) {
        return this.entryFinder.findByKeywords(companyId, userId, keywords, start, end);
    }

    public int searchUsersAndContactsCount(long companyId, long userId, String keywords) {
        return this.entryFinder.countByKeywords(companyId, userId, keywords);
    }

    public Entry updateEntry(long entryId, String fullName, String emailAddress, String comments) throws PortalException {
        Entry entry = this.entryPersistence.findByPrimaryKey(entryId);
        this.validate(entry.getCompanyId(), entryId, entry.getUserId(), fullName, emailAddress);
        entry.setModifiedDate(new Date());
        entry.setFullName(fullName);
        entry.setEmailAddress(emailAddress);
        entry.setComments(comments);
        return (Entry)this.entryPersistence.update((BaseModel)entry);
    }

    protected void validate(long companyId, long entryId, long userId, String fullName, String emailAddress) throws PortalException {
        if (Validator.isNull((String)fullName)) {
            throw new ContactNameException.MustHaveValidFullName(FullNameValidatorFactory.getInstance());
        }
        if (Validator.isNull((String)emailAddress)) {
            throw new RequiredEntryEmailAddressException();
        }
        if (!Validator.isEmailAddress((String)emailAddress)) {
            throw new EntryEmailAddressException();
        }
        if (entryId > 0L) {
            Entry entry = this.entryPersistence.findByPrimaryKey(entryId);
            if (!StringUtil.equalsIgnoreCase((String)emailAddress, (String)entry.getEmailAddress())) {
                this.validateEmailAddress(companyId, userId, emailAddress);
            }
        } else {
            this.validateEmailAddress(companyId, userId, emailAddress);
        }
    }

    protected void validateEmailAddress(long companyId, long userId, String emailAddress) throws PortalException {
        Entry entry = this.entryPersistence.fetchByU_EA(userId, emailAddress);
        if (entry != null) {
            throw new DuplicateEntryEmailAddressException();
        }
        User user = this.userLocalService.fetchUserByEmailAddress(companyId, emailAddress);
        if (user != null) {
            throw new DuplicateEntryEmailAddressException();
        }
    }
}

