/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.uad.anonymizer;

import com.liferay.contacts.model.Entry;
import com.liferay.contacts.service.EntryLocalService;
import com.liferay.contacts.uad.constants.ContactsUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseEntryUADAnonymizer
extends DynamicQueryUADAnonymizer<Entry> {
    @Reference
    protected EntryLocalService entryLocalService;

    public void autoAnonymize(Entry entry, long userId, User anonymousUser) throws PortalException {
        if (entry.getUserId() == userId) {
            entry.setUserId(anonymousUser.getUserId());
            entry.setUserName(anonymousUser.getFullName());
        }
        this.entryLocalService.updateEntry(entry);
    }

    public void delete(Entry entry) throws PortalException {
        this.entryLocalService.deleteEntry(entry);
    }

    public Class<Entry> getTypeClass() {
        return Entry.class;
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.entryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return ContactsUADConstants.USER_ID_FIELD_NAMES_ENTRY;
    }
}

