/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.dashboard.document.library.internal.item.action;

import com.liferay.content.dashboard.item.action.ContentDashboardItemAction;
import com.liferay.info.display.url.provider.InfoEditURLProvider;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.servlet.DynamicServletRequestUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class EditFileEntryContentDashboardItemAction
implements ContentDashboardItemAction {
    private static final Log _log = LogFactoryUtil.getLog(EditFileEntryContentDashboardItemAction.class);
    private final FileEntry _fileEntry;
    private final HttpServletRequest _httpServletRequest;
    private final InfoEditURLProvider<FileEntry> _infoEditURLProvider;
    private final Language _language;
    private final Portal _portal;
    private final PortletLocalService _portletLocalService;

    public EditFileEntryContentDashboardItemAction(FileEntry fileEntry, HttpServletRequest httpServletRequest, InfoEditURLProvider<FileEntry> infoEditURLProvider, Language language, Portal portal, PortletLocalService portletLocalService) {
        this._fileEntry = fileEntry;
        this._httpServletRequest = httpServletRequest;
        this._infoEditURLProvider = infoEditURLProvider;
        this._language = language;
        this._portal = portal;
        this._portletLocalService = portletLocalService;
    }

    public String getIcon() {
        return "pencil";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "edit");
    }

    public String getName() {
        return "edit";
    }

    public ContentDashboardItemAction.Type getType() {
        return ContentDashboardItemAction.Type.EDIT;
    }

    public String getURL() {
        Portlet portlet = this._portletLocalService.getPortletById(this._portal.getPortletId(this._httpServletRequest));
        HttpServletRequest httpServletRequest = DynamicServletRequestUtil.createDynamicServletRequest((HttpServletRequest)this._httpServletRequest, (Portlet)portlet, Collections.singletonMap("redirect", new String[]{this._portal.getCurrentURL(this._httpServletRequest)}), (boolean)true);
        try {
            return Optional.ofNullable(this._infoEditURLProvider.getURL((Object)this._fileEntry, httpServletRequest)).orElse("");
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return "";
        }
    }

    public String getURL(Locale locale) {
        return this.getURL();
    }
}

