Liferay.Loader.define("content-dashboard-web@1.0.50/js/SidebarPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$react', './components/Sidebar'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Sidebar = _interopRequireDefault(require("./components/Sidebar"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var initialState = {
      data: null,
      error: null,
      loading: false,
      open: true
    };

    var dataReducer = function dataReducer(state, action) {
      var _action$data;

      switch (action.type) {
        case 'CLOSE_SIDEBAR':
          return _objectSpread(_objectSpread({}, state), {}, {
            isOpen: false
          });

        case 'LOAD_DATA':
          return _objectSpread(_objectSpread({}, state), {}, {
            data: null,
            error: null,
            loading: true
          });

        case 'OPEN_SIDEBAR':
          return _objectSpread(_objectSpread({}, state), {}, {
            isOpen: true
          });

        case 'SET_ERROR':
          return _objectSpread(_objectSpread({}, state), {}, {
            data: null,
            error: action.error,
            loading: false
          });

        case 'SET_HTML':
          return _objectSpread(_objectSpread({}, state), {}, {
            data: {
              html: action.html
            },
            error: null,
            loading: false
          });

        case 'SET_JSON':
          return _objectSpread(_objectSpread({}, state), {}, {
            data: action.data,
            error: (_action$data = action.data) === null || _action$data === void 0 ? void 0 : _action$data.error,
            loading: false
          });

        default:
          return initialState;
      }
    };

    var SidebarPanel = /*#__PURE__*/_react.default.forwardRef(function (_ref, ref) {
      var fetchURL = _ref.fetchURL,
          onClose = _ref.onClose,
          View = _ref.viewComponent;
      var CurrentView = (0, _react.useRef)(View);
      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

      var _useReducer = (0, _react.useReducer)(dataReducer, initialState),
          _useReducer2 = _slicedToArray(_useReducer, 2),
          state = _useReducer2[0],
          dispatch = _useReducer2[1];

      var safeDispatch = function safeDispatch(action) {
        if (isMounted()) {
          dispatch(action);
        }
      };

      var getData = function getData(fetchURL) {
        safeDispatch({
          type: 'LOAD_DATA'
        });
        (0, _frontendJsWeb.fetch)(fetchURL, {
          method: 'GET'
        }).then(function (response) {
          return response.headers.get('content-type').includes('json') ? response.json().then(function (data) {
            return safeDispatch({
              data: data,
              type: 'SET_JSON'
            });
          }) : response.text().then(function (html) {
            return safeDispatch({
              html: html,
              type: 'SET_HTML'
            });
          });
        }).catch(function () {
          safeDispatch({
            error: Liferay.Language.get('an-unexpected-error-occurred'),
            type: 'SET_ERROR'
          });
        });
      };

      (0, _react.useEffect)(function () {
        getData(fetchURL); // eslint-disable-next-line react-hooks/exhaustive-deps
      }, [fetchURL]);
      (0, _react.useEffect)(function () {
        CurrentView.current = View;
      }, [View]);
      (0, _react.useImperativeHandle)(ref, function () {
        return {
          close: function close() {
            return safeDispatch({
              type: 'CLOSE_SIDEBAR'
            });
          },
          open: function open(fetchURL, View) {
            CurrentView.current = View;
            getData(fetchURL);
            safeDispatch({
              type: 'OPEN_SIDEBAR'
            });
          }
        };
      });
      return (/*#__PURE__*/_react.default.createElement(_Sidebar.default, {
          onClose: function onCloseHandle() {
            return onClose ? onClose() : safeDispatch({
              type: 'CLOSE_SIDEBAR'
            });
          },
          open: state.isOpen
        }, (state === null || state === void 0 ? void 0 : state.loading) ? /*#__PURE__*/_react.default.createElement("div", {
          className: "align-items-center d-flex loading-indicator-wrapper"
        }, /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, {
          small: true
        })) : (state === null || state === void 0 ? void 0 : state.error) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Sidebar.default.Header, null), /*#__PURE__*/_react.default.createElement(_alert.default, {
          displayType: "danger",
          variant: "stripe"
        }, state.error)) : (state === null || state === void 0 ? void 0 : state.data) && /*#__PURE__*/_react.default.createElement(CurrentView.current, state.data))
      );
    });

    var _default = SidebarPanel;
    exports.default = _default;
    //# sourceMappingURL=SidebarPanel.js.map
  }
});
//# sourceMappingURL=SidebarPanel.js.map