Liferay.Loader.define("content-dashboard-web@1.0.50/js/components/AuditBarChart", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/empty-state', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-recharts$recharts', '../utils/constants', '../utils/shortenNumber'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = AuditBarChart;

    var _emptyState = _interopRequireDefault(require("@frontend-taglib-clay$clayui/empty-state"));

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _recharts = require("frontend-js-recharts$recharts");

    var _constants = require("../utils/constants");

    var _shortenNumber = require("../utils/shortenNumber");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function AuditBarChart(_ref) {
      var _vocabularies$, _vocabularies$2, _vocabularies$2$categ, _vocabularies$2$categ2;

      var rtl = _ref.rtl,
          vocabularies = _ref.vocabularies;
      var auditBarChartData = (0, _react.useMemo)(function () {
        var dataKeys = new Set();
        var maxValue = 0;
        var bars = vocabularies.reduce(function (acc, category) {
          if (!category.categories) {
            return acc;
          }

          var newBar = category.categories.reduce(function (childAcc, _ref2) {
            var dataKey = _ref2.key,
                name = _ref2.name;

            if (dataKeys.has(dataKey)) {
              return childAcc;
            }

            dataKeys.add(dataKey);
            return childAcc.concat({
              dataKey: dataKey,
              name: name
            });
          }, []);
          return acc.concat(newBar);
        }, []);
        var data = vocabularies.map(function (category) {
          if (!category.categories) {
            if (Number(category.value) > maxValue) {
              maxValue = Number(category.value);
            }

            return category;
          }

          return category.categories.reduce(function (acc, _ref3) {
            var key = _ref3.key,
                value = _ref3.value;

            if (Number(value) > maxValue) {
              maxValue = Number(value);
            }

            return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, key, value));
          }, {
            name: category.name
          });
        });

        var _bars$reduce = bars.reduce(function (acc, _ref4, index) {
          var dataKey = _ref4.dataKey;
          return {
            colors: _objectSpread(_objectSpread({}, acc.colors), {}, _defineProperty({}, dataKey, _constants.COLORS[index % _constants.COLORS.length])),
            legendCheckboxes: _objectSpread(_objectSpread({}, acc.legendCheckboxes), {}, _defineProperty({}, dataKey, true))
          };
        }, {
          colors: {},
          legendCheckboxes: {}
        }),
            colors = _bars$reduce.colors,
            legendCheckboxes = _bars$reduce.legendCheckboxes;

        return {
          bars: bars,
          colors: colors,
          data: data,
          legendCheckboxes: legendCheckboxes,
          maxValue: maxValue
        };
      }, [vocabularies]);
      var bars = auditBarChartData.bars,
          colors = auditBarChartData.colors,
          data = auditBarChartData.data,
          legendCheckboxes = auditBarChartData.legendCheckboxes,
          maxValue = auditBarChartData.maxValue;

      var _useState = (0, _react.useState)(legendCheckboxes),
          _useState2 = _slicedToArray(_useState, 2),
          checkboxes = _useState2[0],
          setCheckbox = _useState2[1];

      (0, _react.useEffect)(function () {
        var style;

        if (Object.keys(colors).length) {
          style = document.createElement('style');
          style.type = 'text/css';
          style.textContent = Object.entries(colors).reduce(function (acc, _ref5) {
            var _ref6 = _slicedToArray(_ref5, 2),
                dataKey = _ref6[0],
                color = _ref6[1];

            return acc.concat("\n\t\t\t\t\t\t.custom-control-color-".concat(dataKey, ".custom-control-input:checked ~ \n\t\t\t\t\t\t\t.custom-control-label::before {\n\t\t\t\t\t\t\t\tbackground-color: ").concat(color, ";\n\t\t\t\t\t\t\t\tborder-color: ").concat(color, ";\n\t\t\t\t\t\t}\n\t\t\t\t\t\t.custom-control-color-").concat(dataKey, ".custom-control-input:not(:checked) ~ \n\t\t\t\t\t\t\t.custom-control-label::before {\n\t\t\t\t\t\t\t\tborder-color: ").concat(color, ";\n\t\t\t\t\t\t}\n\t\t\t\t\t"));
          }, '');
          document.head.appendChild(style);
        }

        return function () {
          if (style) {
            document.head.removeChild(style);
          }
        };
      }, [colors]);

      var showLegend = !!bars.length;
      var axisNames = {
        x: (_vocabularies$ = vocabularies[0]) === null || _vocabularies$ === void 0 ? void 0 : _vocabularies$.vocabularyName,
        y: showLegend && ((_vocabularies$2 = vocabularies[0]) === null || _vocabularies$2 === void 0 ? void 0 : (_vocabularies$2$categ = _vocabularies$2.categories) === null || _vocabularies$2$categ === void 0 ? void 0 : (_vocabularies$2$categ2 = _vocabularies$2$categ[0]) === null || _vocabularies$2$categ2 === void 0 ? void 0 : _vocabularies$2$categ2.vocabularyName)
      };
      var noCheckboxesChecked = Object.keys(checkboxes).every(function (i) {
        return checkboxes[i] === false;
      });

      var _useState3 = (0, _react.useState)(null),
          _useState4 = _slicedToArray(_useState3, 2),
          tooltip = _useState4[0],
          setTooltip = _useState4[1];

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.keys(checkboxes).length > 0 && noCheckboxesChecked && /*#__PURE__*/_react.default.createElement(_emptyState.default, {
          className: "empty-state no-categories-selected text-center",
          description: Liferay.Language.get('select-categories-from-the-checkboxes-in-the-legend-above'),
          title: Liferay.Language.get('there-are-no-categories-selected')
        }), /*#__PURE__*/_react.default.createElement("div", {
          className: "mb-3 overflow-auto"
        }, /*#__PURE__*/_react.default.createElement(_recharts.BarChart, {
          data: data,
          height: _constants.BAR_CHART.height,
          width: _constants.BAR_CHART.width
        }, showLegend && /*#__PURE__*/_react.default.createElement(_recharts.Legend, {
          align: rtl ? 'right' : 'left',
          content: function renderLegend(props) {
            var payload = props.payload,
                yAxisName = props.yAxisName;
            return (/*#__PURE__*/_react.default.createElement(_layout.default.ContainerFluid, null, /*#__PURE__*/_react.default.createElement(_layout.default.Row, null, /*#__PURE__*/_react.default.createElement(_layout.default.Col, {
                size: 1
              }, /*#__PURE__*/_react.default.createElement("span", {
                className: "small"
              }, yAxisName, ":")), /*#__PURE__*/_react.default.createElement(_layout.default.Col, null, /*#__PURE__*/_react.default.createElement(_layout.default.Row, null, payload.map(function (entry) {
                return (/*#__PURE__*/_react.default.createElement(_layout.default.Col, {
                    className: "c-mb-2",
                    key: entry.dataKey,
                    size: 2
                  }, /*#__PURE__*/_react.default.createElement(_form.ClayCheckbox, {
                    "aria-labelledby": entry.value,
                    checked: checkboxes[entry.dataKey],
                    className: "custom-control-color-".concat(entry.dataKey),
                    inline: true,
                    onChange: function onChange() {
                      return setCheckbox(_objectSpread(_objectSpread({}, checkboxes), {}, _defineProperty({}, entry.dataKey, !checkboxes[entry.dataKey])));
                    }
                  }, /*#__PURE__*/_react.default.createElement("span", {
                    className: "inline-item-after small text-secondary"
                  }, entry.value)))
                );
              })))))
            );
          },
          verticalAlign: "top",
          wrapperStyle: {
            paddingBottom: 24
          },
          yAxisName: axisNames.y
        }), /*#__PURE__*/_react.default.createElement(_recharts.CartesianGrid, {
          stroke: _constants.BAR_CHART.stroke
        }), /*#__PURE__*/_react.default.createElement(_recharts.XAxis, {
          axisLine: {
            stroke: _constants.BAR_CHART.stroke
          },
          dataKey: "name",
          height: 90,
          interval: 0,
          label: {
            className: 'small',
            offset: 18,
            position: 'insideBottom',
            value: axisNames.x
          },
          reversed: rtl,
          tick: /*#__PURE__*/_react.default.createElement(CustomXAxisTick, null),
          tickLine: false
        }), /*#__PURE__*/_react.default.createElement(_recharts.YAxis, {
          allowDataOverflow: true,
          allowDecimals: false,
          axisLine: {
            stroke: _constants.BAR_CHART.stroke
          },
          domain: [0, maxValue],
          orientation: rtl ? 'right' : 'left',
          tick: /*#__PURE__*/_react.default.createElement(CustomYAxisTick, {
            rtl: rtl
          }),
          tickLine: false,
          width: 45
        }), /*#__PURE__*/_react.default.createElement(_recharts.Tooltip, {
          animationDuration: 0,
          content: /*#__PURE__*/_react.default.createElement(CustomTooltip, null),
          cursor: {
            fill: 'transparent'
          },
          tooltip: tooltip
        }), bars.length && bars.map(function (bar, index) {
          return (/*#__PURE__*/_react.default.createElement(_recharts.Bar, {
              barSize: checkboxes[bar.dataKey] === true ? _constants.BAR_CHART.barHeight : 0,
              dataKey: bar.dataKey,
              hide: checkboxes[bar.dataKey] !== true,
              key: index,
              legendType: "square",
              name: bar.name,
              onMouseOut: function onMouseOut() {
                setTooltip(null);
              },
              onMouseOver: function onMouseOver(props) {
                setTooltip({
                  dataKey: bar.dataKey,
                  name: props.name
                });
              }
            }, data.map(function (entry, index) {
              return (/*#__PURE__*/_react.default.createElement(_recharts.Cell, {
                  fill: colors[bar.dataKey],
                  key: "cell-".concat(index),
                  opacity: !tooltip ? 1 : tooltip.dataKey === bar.dataKey && entry.name === tooltip.name ? 1 : 0.4
                })
              );
            }))
          );
        }), !bars.length && /*#__PURE__*/_react.default.createElement(_recharts.Bar, {
          barSize: _constants.BAR_CHART.barHeight,
          dataKey: "value",
          onMouseOut: function onMouseOut() {
            setTooltip(null);
          },
          onMouseOver: function onMouseOver(props) {
            setTooltip({
              dataKey: 'value',
              name: props.name
            });
          }
        }, data.map(function (entry, index) {
          return (/*#__PURE__*/_react.default.createElement(_recharts.Cell, {
              fill: _constants.COLORS[0],
              key: "cell-".concat(index),
              opacity: !tooltip ? 1 : tooltip.dataKey === 'value' && entry.name === tooltip.name ? 1 : 0.4
            })
          );
        })))))
      );
    }

    function CustomTooltip(props) {
      var active = props.active,
          label = props.label,
          payload = props.payload,
          tooltip = props.tooltip;

      if (!active || !tooltip) {
        return null;
      }

      for (var i = 0; i <= payload.length; i++) {
        if (payload[i].dataKey === tooltip.dataKey) {
          return (/*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, {
              className: "bg-white custom-tooltip p-1 rounded small text-secondary",
              padded: true,
              style: {
                width: 150
              }
            }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
              expand: true
            }, payload[i].payload.vocabularyName ? label : payload[i].name), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, null, payload[i].value))
          );
        }
      }

      return null;
    }

    function CustomXAxisTick(props) {
      var payload = props.payload,
          x = props.x,
          y = props.y;
      return (/*#__PURE__*/_react.default.createElement(_recharts.Text, {
          fill: _constants.BAR_CHART.fillXAxis,
          fontSize: 14,
          textAnchor: "middle",
          verticalAnchor: "start",
          width: 120,
          x: x,
          y: y + _constants.BAR_CHART.axisMargin
        }, payload.value)
      );
    }

    function CustomYAxisTick(props) {
      var payload = props.payload,
          rtl = props.rtl,
          x = props.x,
          y = props.y;
      return (/*#__PURE__*/_react.default.createElement(_recharts.Text, {
          fill: _constants.BAR_CHART.fillXAxis,
          fontSize: 14,
          textAnchor: "end",
          verticalAnchor: "end",
          x: rtl ? x + _constants.BAR_CHART.axisMargin : x - _constants.BAR_CHART.axisMargin,
          y: y
        }, (0, _shortenNumber.shortenNumber)(payload.value))
      );
    }
    //# sourceMappingURL=AuditBarChart.js.map
  }
});
//# sourceMappingURL=AuditBarChart.js.map