Liferay.Loader.define("content-dashboard-web@1.0.50/js/components/EmptyAuditBarChart", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/empty-state', 'frontend-js-react-web$react', 'frontend-js-recharts$recharts', '../utils/constants'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = EmptyAuditBarChart;

    var _emptyState = _interopRequireDefault(require("@frontend-taglib-clay$clayui/empty-state"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _recharts = require("frontend-js-recharts$recharts");

    var _constants = require("../utils/constants");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function EmptyAuditBarChart(_ref) {
      var learnHowURL = _ref.learnHowURL;

      var description = learnHowURL && /*#__PURE__*/_react.default.createElement("div", {
        dangerouslySetInnerHTML: {
          __html: Liferay.Util.sub(Liferay.Language.get('x-learn-how-x-to-tailor-categories-to-your-needs'), "<a href=".concat(learnHowURL, " target=\"_blank\">"), '</a>')
        }
      });

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_emptyState.default, {
          className: "empty-state text-center",
          description: description,
          title: Liferay.Language.get('there-is-no-data')
        }), /*#__PURE__*/_react.default.createElement(_recharts.ResponsiveContainer, {
          height: _constants.BAR_CHART.emptyHeight
        }, /*#__PURE__*/_react.default.createElement(_recharts.BarChart, {
          data: [],
          height: _constants.BAR_CHART.emptyHeight,
          width: _constants.BAR_CHART.width
        }, /*#__PURE__*/_react.default.createElement(_recharts.CartesianGrid, {
          stroke: _constants.BAR_CHART.stroke
        }), /*#__PURE__*/_react.default.createElement(_recharts.XAxis, {
          axisLine: {
            stroke: _constants.BAR_CHART.stroke
          },
          tickLine: false
        }), /*#__PURE__*/_react.default.createElement(_recharts.YAxis, {
          axisLine: {
            stroke: _constants.BAR_CHART.stroke
          },
          domain: [0, 40],
          tickLine: false
        }))))
      );
    }
    //# sourceMappingURL=EmptyAuditBarChart.js.map
  }
});
//# sourceMappingURL=EmptyAuditBarChart.js.map