Liferay.Loader.define("content-dashboard-web@1.0.50/js/components/SidebarPanelInfoView", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/label', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/link', '@frontend-taglib-clay$clayui/sticker', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', './Sidebar'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _link = _interopRequireDefault(require("@frontend-taglib-clay$clayui/link"));

    var _sticker = _interopRequireDefault(require("@frontend-taglib-clay$clayui/sticker"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _classnames2 = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Sidebar = _interopRequireDefault(require("./Sidebar"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var formatDate = function formatDate(date, languageTag) {
      return date && languageTag && Intl.DateTimeFormat(languageTag, {
        day: 'numeric',
        hour: 'numeric',
        hour12: true,
        minute: 'numeric',
        month: 'short',
        year: 'numeric'
      }).format(new Date(date));
    };

    var SidebarPanelInfoView = function SidebarPanelInfoView(_ref) {
      var _data$displayDate, _data$expirationDate, _data$reviewDate;

      var _ref$categories = _ref.categories,
          categories = _ref$categories === void 0 ? [] : _ref$categories,
          classPK = _ref.classPK,
          createDate = _ref.createDate,
          _ref$data = _ref.data,
          data = _ref$data === void 0 ? {} : _ref$data,
          _ref$languageTag = _ref.languageTag,
          languageTag = _ref$languageTag === void 0 ? 'en' : _ref$languageTag,
          modifiedDate = _ref.modifiedDate,
          subType = _ref.subType,
          _ref$tags = _ref.tags,
          tags = _ref$tags === void 0 ? [] : _ref$tags,
          title = _ref.title,
          user = _ref.user,
          _ref$versions = _ref.versions,
          versions = _ref$versions === void 0 ? [] : _ref$versions,
          _ref$viewURLs = _ref.viewURLs,
          viewURLs = _ref$viewURLs === void 0 ? [] : _ref$viewURLs;
      var sortedViewURLS = (0, _react.useMemo)(function () {
        return viewURLs.sort(function (a, b) {
          if (a.languageId < b.languageId) {
            return -1;
          }

          if (a.languageId > b.languageId) {
            return 1;
          }

          return 0;
        }).sort(function (a) {
          if (a.default) {
            return -1;
          }

          return 0;
        });
      }, [viewURLs]);
      var stickerColor = parseInt(user.userId, 10) % 10;
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Sidebar.default.Header, {
          title: Liferay.Language.get('content-info')
        }), /*#__PURE__*/_react.default.createElement(_Sidebar.default.Body, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "c-mb-4"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "component-title text-truncate-inline"
        }, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("span", {
          className: "text-truncate",
          "data-tooltip-align": "top",
          title: title
        }, title))), /*#__PURE__*/_react.default.createElement("p", {
          className: "component-subtitle font-weight-normal"
        }, subType), versions.map(function (version) {
          return (/*#__PURE__*/_react.default.createElement("div", {
              key: version.version
            }, /*#__PURE__*/_react.default.createElement(_label.default, {
              displayType: "info"
            }, Liferay.Language.get('version'), ' ', version.version), /*#__PURE__*/_react.default.createElement(_label.default, {
              displayType: version.statusStyle
            }, version.statusLabel))
          );
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "c-mb-4 sidebar-dl sidebar-section"
        }, /*#__PURE__*/_react.default.createElement(_sticker.default, {
          className: (0, _classnames2.default)('sticker-user-icon', _defineProperty({}, "user-icon-color-".concat(stickerColor), !user.url)),
          shape: "circle"
        }, user.url ? /*#__PURE__*/_react.default.createElement("img", {
          alt: "".concat(user.name, "."),
          className: "sticker-img",
          src: user.url
        }) : /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "user"
        })), /*#__PURE__*/_react.default.createElement("span", {
          className: "c-ml-2 h5"
        }, user.name)), !!sortedViewURLS.length && /*#__PURE__*/_react.default.createElement("div", {
          className: "c-mb-4 sidebar-dl sidebar-section"
        }, /*#__PURE__*/_react.default.createElement("h5", null, Liferay.Language.get('languages-translated-into')), sortedViewURLS.map(function (language) {
          return (/*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, {
              key: language.languageId,
              verticalAlign: "center"
            }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
              className: "inline-item-before"
            }, /*#__PURE__*/_react.default.createElement(_icon.default, {
              className: "c-mt-1",
              symbol: language.languageId.toLowerCase()
            })), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
              expand: !!language.viewURL
            }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, {
              key: language.languageId,
              verticalAlign: "center"
            }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
              className: "inline-item-before small"
            }, language.languageId), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, null, language.default && /*#__PURE__*/_react.default.createElement(_label.default, {
              className: "d-inline",
              displayType: "info"
            }, Liferay.Language.get('default'))))), language.viewURL && /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, null, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement(_link.default, {
              borderless: true,
              "data-tooltip-align": "top",
              displayType: "secondary",
              href: language.viewURL,
              monospaced: true,
              outline: true,
              title: Liferay.Language.get('view')
            }, /*#__PURE__*/_react.default.createElement(_icon.default, {
              symbol: "view"
            })))))
          );
        })), !!tags.length && /*#__PURE__*/_react.default.createElement("div", {
          className: "c-mb-4 sidebar-dl sidebar-section"
        }, /*#__PURE__*/_react.default.createElement("h5", null, Liferay.Language.get('tags')), /*#__PURE__*/_react.default.createElement("p", null, tags.map(function (tag) {
          return (/*#__PURE__*/_react.default.createElement(_label.default, {
              displayType: "secondary",
              key: tag
            }, tag)
          );
        }))), !!categories.length && /*#__PURE__*/_react.default.createElement("div", {
          className: "c-mb-4 sidebar-dl sidebar-section"
        }, /*#__PURE__*/_react.default.createElement("h5", null, Liferay.Language.get('categories')), /*#__PURE__*/_react.default.createElement("p", null, categories.map(function (category) {
          return (/*#__PURE__*/_react.default.createElement(_label.default, {
              displayType: "secondary",
              key: category
            }, category)
          );
        }))), [{
          text: formatDate((_data$displayDate = data['display-date']) === null || _data$displayDate === void 0 ? void 0 : _data$displayDate.value, languageTag),
          title: Liferay.Language.get('display-date')
        }, {
          text: formatDate(createDate, languageTag),
          title: Liferay.Language.get('creation-date')
        }, {
          text: formatDate(modifiedDate, languageTag),
          title: Liferay.Language.get('modified-date')
        }, {
          text: formatDate((_data$expirationDate = data['expiration-date']) === null || _data$expirationDate === void 0 ? void 0 : _data$expirationDate.value, languageTag),
          title: Liferay.Language.get('expiration-date')
        }, {
          text: formatDate((_data$reviewDate = data['review-date']) === null || _data$reviewDate === void 0 ? void 0 : _data$reviewDate.value, languageTag),
          title: Liferay.Language.get('review-date')
        }, {
          text: classPK,
          title: Liferay.Language.get('id')
        }].map(function (_ref2) {
          var text = _ref2.text,
              title = _ref2.title;
          return text && title && /*#__PURE__*/_react.default.createElement("div", {
            className: "c-mb-4 sidebar-dl sidebar-section",
            key: title
          }, /*#__PURE__*/_react.default.createElement("h5", null, title), /*#__PURE__*/_react.default.createElement("p", null, text));
        })))
      );
    };

    var _default = SidebarPanelInfoView;
    exports.default = _default;
    //# sourceMappingURL=SidebarPanelInfoView.js.map
  }
});
//# sourceMappingURL=SidebarPanelInfoView.js.map