Liferay.Loader.define("content-dashboard-web@1.0.50/js/transformers/ActionsComponentPropsTransformer", ['module', 'exports', 'require', 'frontend-js-react-web', '../SidebarPanel', '../components/SidebarPanelInfoView', '../components/SidebarPanelMetricsView'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = propsTransformer;

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _SidebarPanel = _interopRequireDefault(require("../SidebarPanel"));

    var _SidebarPanelInfoView = _interopRequireDefault(require("../components/SidebarPanelInfoView"));

    var _SidebarPanelMetricsView = _interopRequireDefault(require("../components/SidebarPanelMetricsView"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    var deselectAllRows = function deselectAllRows(portletNamespace) {
      var activeRows = document.querySelectorAll("[data-searchcontainerid=\"".concat(portletNamespace, "content\"] tr.active"));
      activeRows.forEach(function (row) {
        return row.classList.remove('active');
      });
    };

    var getRow = function getRow(portletNamespace, rowId) {
      return document.querySelector("[data-searchcontainerid=\"".concat(portletNamespace, "content\"] [data-rowid=\"").concat(rowId, "\"]"));
    };

    var selectRow = function selectRow(portletNamespace, rowId) {
      deselectAllRows(portletNamespace);
      var currentRow = getRow(portletNamespace, rowId);
      currentRow.classList.add('active');
    };

    var showSidebar = function showSidebar(_ref) {
      var View = _ref.View,
          fetchURL = _ref.fetchURL,
          portletNamespace = _ref.portletNamespace;
      var id = "".concat(portletNamespace, "sidebar");
      var sidebarPanel = Liferay.component(id);

      if (!sidebarPanel) {
        var container = document.body.appendChild(document.createElement('div'));
        (0, _frontendJsReactWeb.render)(_SidebarPanel.default, {
          fetchURL: fetchURL,
          onClose: function onClose() {
            Liferay.component(id).close();
            deselectAllRows(portletNamespace);
          },
          ref: function ref(element) {
            Liferay.component(id, element);
          },
          viewComponent: View
        }, container);
      } else {
        sidebarPanel.open(fetchURL, View);
      }
    };

    var actions = {
      showInfo: function showInfo(_ref2) {
        var fetchURL = _ref2.fetchURL,
            portletNamespace = _ref2.portletNamespace,
            rowId = _ref2.rowId;
        selectRow(portletNamespace, rowId);
        showSidebar({
          View: _SidebarPanelInfoView.default,
          fetchURL: fetchURL,
          portletNamespace: portletNamespace
        });
      },
      showMetrics: function showMetrics(_ref3) {
        var fetchURL = _ref3.fetchURL,
            portletNamespace = _ref3.portletNamespace,
            rowId = _ref3.rowId;
        selectRow(portletNamespace, rowId);
        showSidebar({
          View: _SidebarPanelMetricsView.default,
          fetchURL: fetchURL,
          portletNamespace: portletNamespace
        });
      }
    };

    function propsTransformer(_ref4) {
      var items = _ref4.items,
          portletNamespace = _ref4.portletNamespace,
          otherProps = _objectWithoutProperties(_ref4, ["items", "portletNamespace"]);

      return _objectSpread(_objectSpread({}, otherProps), {}, {
        items: items.map(function (item) {
          return _objectSpread(_objectSpread({}, item), {}, {
            onClick: function onClick(event) {
              var _item$data;

              var action = (_item$data = item.data) === null || _item$data === void 0 ? void 0 : _item$data.action;

              if (action) {
                event.preventDefault();
                actions[action]({
                  fetchURL: item.data.fetchURL,
                  portletNamespace: portletNamespace,
                  rowId: item.data.classPK
                });
              }
            }
          });
        })
      });
    }
    //# sourceMappingURL=ActionsComponentPropsTransformer.js.map
  }
});
//# sourceMappingURL=ActionsComponentPropsTransformer.js.map