Liferay.Loader.define("content-dashboard-web$d3-shape@1.3.7/src/curve/bundle", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import { Basis } from "./basis.js";

    function Bundle(context, beta) {
      this._basis = new Basis(context);
      this._beta = beta;
    }

    Bundle.prototype = {
      lineStart: function () {
        this._x = [];
        this._y = [];
        this._basis.lineStart();
      },
      lineEnd: function () {
        var x = this._x,
            y = this._y,
            j = x.length - 1;

        if (j > 0) {
          var x0 = x[0],
              y0 = y[0],
              dx = x[j] - x0,
              dy = y[j] - y0,
              i = -1,
              t;

          while (++i <= j) {
            t = i / j;
            this._basis.point(this._beta * x[i] + (1 - this._beta) * (x0 + t * dx), this._beta * y[i] + (1 - this._beta) * (y0 + t * dy));
          }
        }

        this._x = this._y = null;
        this._basis.lineEnd();
      },
      point: function (x, y) {
        this._x.push(+x);
        this._y.push(+y);
      }
    };

    export default (function custom(beta) {

      function bundle(context) {
        return beta === 1 ? new Basis(context) : new Bundle(context, beta);
      }

      bundle.beta = function (beta) {
        return custom(+beta);
      };

      return bundle;
    })(0.85);
  }
});
//# sourceMappingURL=bundle.js.map