"use strict";

Liferay.Loader.define("content-dashboard-web$dom-helpers@3.4.0/transition/end", ['module', 'exports', 'require', '@content-dashboard-web$babel/runtime/helpers/interopRequireDefault', './properties', '../style'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var _interopRequireDefault = require("@content-dashboard-web$babel/runtime/helpers/interopRequireDefault");

    exports.__esModule = true;
    exports.default = void 0;

    var _properties = _interopRequireDefault(require("./properties"));

    var _style = _interopRequireDefault(require("../style"));

    function onEnd(node, handler, duration) {
      var fakeEvent = {
        target: node,
        currentTarget: node
      },
          backup;
      if (!_properties.default.end) duration = 0;else if (duration == null) duration = parseDuration(node) || 0;

      if (_properties.default.end) {
        node.addEventListener(_properties.default.end, done, false);
        backup = setTimeout(function () {
          return done(fakeEvent);
        }, (duration || 100) * 1.5);
      } else setTimeout(done.bind(null, fakeEvent), 0);

      function done(event) {
        if (event.target !== event.currentTarget) return;
        clearTimeout(backup);
        event.target.removeEventListener(_properties.default.end, done);
        handler.call(this);
      }
    }

    onEnd._parseDuration = parseDuration;
    var _default = onEnd;
    exports.default = _default;

    function parseDuration(node) {
      var str = (0, _style.default)(node, _properties.default.duration),
          mult = str.indexOf('ms') === -1 ? 1000 : 1;
      return parseFloat(str) * mult;
    }

    module.exports = exports["default"];
  }
});
//# sourceMappingURL=end.js.map