"use strict";

Liferay.Loader.define("content-dashboard-web$react-smooth@1.0.5/lib/AnimateManager", ['module', 'exports', 'require', './setRafTimeout'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = createAnimateManager;

    var _setRafTimeout = _interopRequireDefault(require("./setRafTimeout"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _toArray(arr) {
      return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function createAnimateManager() {
      var currStyle = {};

      var handleChange = function handleChange() {
        return null;
      };

      var shouldStop = false;

      var setStyle = function setStyle(_style) {
        if (shouldStop) {
          return;
        }

        if (Array.isArray(_style)) {
          if (!_style.length) {
            return;
          }

          var _styles = _toArray(_style),
              curr = _styles[0],
              restStyles = _styles.slice(1);

          if (typeof curr === 'number') {
            (0, _setRafTimeout.default)(setStyle.bind(null, restStyles), curr);
            return;
          }

          setStyle(curr);
          (0, _setRafTimeout.default)(setStyle.bind(null, restStyles));
          return;
        }

        if (_typeof(_style) === 'object') {
          currStyle = _style;
          handleChange(currStyle);
        }

        if (typeof _style === 'function') {
          _style();
        }
      };

      return {
        stop: function stop() {
          shouldStop = true;
        },
        start: function start(style) {
          shouldStop = false;
          setStyle(style);
        },
        subscribe: function subscribe(_handleChange) {
          handleChange = _handleChange;
          return function () {
            handleChange = function handleChange() {
              return null;
            };
          };
        }
      };
    }
  }
});
//# sourceMappingURL=AnimateManager.js.map