"use strict";

Liferay.Loader.define("content-dashboard-web$recharts-scale@0.4.3/lib/util/arithmetic", ['module', 'exports', 'require', 'content-dashboard-web$decimal.js-light', './utils'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _decimal = _interopRequireDefault(require("content-dashboard-web$decimal.js-light"));

    var _utils = require("./utils");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @fileOverview 一些公用的运算方法
     * @author xile611
     * @date 2015-09-17
     */

    /**
     * 获取数值的位数
     * 其中绝对值属于区间[0.1, 1)， 得到的值为0
     * 绝对值属于区间[0.01, 0.1)，得到的位数为 -1
     * 绝对值属于区间[0.001, 0.01)，得到的位数为 -2
     *
     * @param  {Number} value 数值
     * @return {Integer} 位数
     */
    function getDigitCount(value) {
      var result;

      if (value === 0) {
        result = 1;
      } else {
        result = Math.floor(new _decimal.default(value).abs().log(10).toNumber()) + 1;
      }

      return result;
    }
    /**
     * 按照固定的步长获取[start, end)这个区间的数据
     * 并且需要处理js计算精度的问题
     *
     * @param  {Decimal} start 起点
     * @param  {Decimal} end   终点，不包含该值
     * @param  {Decimal} step  步长
     * @return {Array}         若干数值
     */

    function rangeStep(start, end, step) {
      var num = new _decimal.default(start);
      var i = 0;
      var result = []; // magic number to prevent infinite loop

      while (num.lt(end) && i < 100000) {
        result.push(num.toNumber());
        num = num.add(step);
        i++;
      }

      return result;
    }
    /**
     * 对数值进行线性插值
     *
     * @param  {Number} a  定义域的极点
     * @param  {Number} b  定义域的极点
     * @param  {Number} t  [0, 1]内的某个值
     * @return {Number}    定义域内的某个值
     */

    var interpolateNumber = (0, _utils.curry)(function (a, b, t) {
      var newA = +a;

      return newA + t * (+b - newA);
    });
    /**
     * 线性插值的逆运算
     *
     * @param  {Number} a 定义域的极点
     * @param  {Number} b 定义域的极点
     * @param  {Number} x 可以认为是插值后的一个输出值
     * @return {Number}   当x在 a ~ b这个范围内时，返回值属于[0, 1]
     */

    var uninterpolateNumber = (0, _utils.curry)(function (a, b, x) {
      var diff = b - +a;
      diff = diff || Infinity;
      return (x - a) / diff;
    });
    /**
     * 线性插值的逆运算，并且有截断的操作
     *
     * @param  {Number} a 定义域的极点
     * @param  {Number} b 定义域的极点
     * @param  {Number} x 可以认为是插值后的一个输出值
     * @return {Number}   当x在 a ~ b这个区间内时，返回值属于[0, 1]，
     * 当x不在 a ~ b这个区间时，会截断到 a ~ b 这个区间
     */

    var uninterpolateTruncation = (0, _utils.curry)(function (a, b, x) {
      var diff = b - +a;
      diff = diff || Infinity;
      return Math.max(0, Math.min(1, (x - a) / diff));
    });
    var _default = {
      rangeStep: rangeStep,
      getDigitCount: getDigitCount,
      interpolateNumber: interpolateNumber,
      uninterpolateNumber: uninterpolateNumber,
      uninterpolateTruncation: uninterpolateTruncation
    };
    exports.default = _default;
  }
});
//# sourceMappingURL=arithmetic.js.map