/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.cookies.internal.manager;

import com.liferay.cookies.configuration.CookiesPreferenceHandlingConfiguration;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.cookies.CookiesManager;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.cookies.UnsupportedCookieException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.cookies.configuration.CookiesPreferenceHandlingConfiguration"}, property={"cookies.functional=GUEST_LANGUAGE_ID", "cookies.necessary=CONSENT_TYPE_FUNCTIONAL", "cookies.necessary=CONSENT_TYPE_NECESSARY", "cookies.necessary=CONSENT_TYPE_PERFORMANCE", "cookies.necessary=CONSENT_TYPE_PERSONALIZATION", "cookies.necessary=COOKIE_SUPPORT", "cookies.necessary=USER_CONSENT_CONFIGURED"}, service={CookiesManager.class})
public class CookiesManagerImpl
implements CookiesManager {
    private static final String _SESSION_COOKIE_DOMAIN = PropsUtil.get((String)"session.cookie.domain");
    private static final boolean _SESSION_COOKIE_USE_FULL_HOSTNAME = GetterUtil.getBoolean((String)PropsUtil.get((String)"session.cookie.use.full.hostname", (Filter)new Filter(ServerDetector.getServerId())));
    private static final boolean _SESSION_ENABLE_PERSISTENT_COOKIES = GetterUtil.getBoolean((String)PropsUtil.get((String)"session.enable.persistent.cookies"));
    private static final boolean _SESSION_TEST_COOKIE_SUPPORT = GetterUtil.getBoolean((String)PropsUtil.get((String)"session.test.cookie.support"));
    private static final Log _log = LogFactoryUtil.getLog(CookiesManagerImpl.class);
    private static final Map<String, Integer> _internalCookies = new HashMap<String, Integer>();
    private static final Map<String, Integer> _knownCookies = new HashMap<String, Integer>();
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;

    public boolean addCookie(Cookie cookie, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean secure = false;
        if (httpServletRequest != null) {
            secure = this._portal.isSecure(httpServletRequest);
        } else if (cookie != null) {
            secure = cookie.getSecure();
        }
        return this.addCookie(cookie, httpServletRequest, httpServletResponse, secure);
    }

    public boolean addCookie(Cookie cookie, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean secure) {
        if (_internalCookies.get(cookie.getName()) != null) {
            return this.addCookie(_internalCookies.get(cookie.getName()), cookie, httpServletRequest, httpServletResponse, secure);
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("The following cookie is trying to be added without consent type: " + cookie.getName()));
        }
        if (_knownCookies.get(cookie.getName()) != null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"The cookie will be added with the consent type used previously. Use the API with explicitly declared consent type.");
            }
            return this.addCookie(_knownCookies.get(cookie.getName()), cookie, httpServletRequest, httpServletResponse, secure);
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"The cookie will be deleted. Use the API with explicitly declared consent type.");
        }
        return this.deleteCookies(CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest), httpServletRequest, httpServletResponse, cookie.getName());
    }

    public boolean addCookie(int consentType, Cookie cookie, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.addCookie(consentType, cookie, httpServletRequest, httpServletResponse, this._portal.isSecure(httpServletRequest));
    }

    public boolean addCookie(int consentType, Cookie cookie, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean secure) {
        String originalCookieValue;
        if (!_SESSION_ENABLE_PERSISTENT_COOKIES) {
            return false;
        }
        if (cookie.getMaxAge() != 0) {
            CookiesPreferenceHandlingConfiguration cookiesPreferenceHandlingConfiguration = this._getCookiesPreferenceHandlingConfiguration(httpServletRequest);
            if (!cookiesPreferenceHandlingConfiguration.enabled()) {
                this._deleteCookieConsentCookies(httpServletRequest, httpServletResponse);
            } else if (!this.hasConsentType(consentType, httpServletRequest)) {
                return false;
            }
        }
        cookie.setSecure(secure);
        String encodedCookieValue = originalCookieValue = cookie.getValue();
        if (this.isEncodedCookie(cookie.getName())) {
            encodedCookieValue = UnicodeFormatter.bytesToHex((byte[])originalCookieValue.getBytes());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Add encoded cookie " + cookie.getName()));
                _log.debug((Object)("Original value " + originalCookieValue));
                _log.debug((Object)("Hex encoded value " + encodedCookieValue));
            }
        }
        cookie.setValue(encodedCookieValue);
        cookie.setVersion(0);
        httpServletResponse.addCookie(cookie);
        if (httpServletRequest != null) {
            Map<String, Cookie> cookiesMap = this._getCookiesMap(httpServletRequest);
            cookiesMap.put(StringUtil.toUpperCase((String)cookie.getName()), cookie);
        }
        if (_log.isWarnEnabled() && _knownCookies.get(cookie.getName()) != null && _knownCookies.get(cookie.getName()) != consentType) {
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"The ", cookie.getName(), " cookie was previously added with consent type ", _knownCookies.get(cookie.getName()), " and will now be modified to consent type ", consentType}));
        }
        _knownCookies.put(cookie.getName(), consentType);
        return true;
    }

    public boolean addSupportCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie cookieSupportCookie = new Cookie("COOKIE_SUPPORT", "true");
        cookieSupportCookie.setMaxAge(31536000);
        cookieSupportCookie.setPath("/");
        return this.addCookie(2, cookieSupportCookie, null, httpServletResponse, this._portal.isSecure(httpServletRequest));
    }

    public boolean deleteCookies(String domain, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String ... cookieNames) {
        if (!_SESSION_ENABLE_PERSISTENT_COOKIES) {
            return false;
        }
        Map<String, Cookie> cookiesMap = this._getCookiesMap(httpServletRequest);
        for (String cookieName : cookieNames) {
            Cookie cookie = cookiesMap.remove(StringUtil.toUpperCase((String)cookieName));
            if (cookie == null) continue;
            if (domain != null) {
                cookie.setDomain(domain);
            }
            cookie.setMaxAge(0);
            cookie.setPath("/");
            cookie.setValue("");
            httpServletResponse.addCookie(cookie);
        }
        return true;
    }

    public String getCookieValue(String cookieName, HttpServletRequest httpServletRequest) {
        return this.getCookieValue(cookieName, httpServletRequest, true);
    }

    public String getCookieValue(String cookieName, HttpServletRequest httpServletRequest, boolean toUpperCase) {
        if (!_SESSION_ENABLE_PERSISTENT_COOKIES) {
            return null;
        }
        String cookieValue = this._getCookieValue(cookieName, httpServletRequest, toUpperCase);
        if (cookieValue == null || !this.isEncodedCookie(cookieName)) {
            return cookieValue;
        }
        try {
            String encodedCookieValue = cookieValue;
            String originalCookieValue = new String(UnicodeFormatter.hexToBytes((String)encodedCookieValue));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Get encoded cookie " + cookieName));
                _log.debug((Object)("Hex encoded value " + encodedCookieValue));
                _log.debug((Object)("Original value " + originalCookieValue));
            }
            return originalCookieValue;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return cookieValue;
        }
    }

    public String getDomain(HttpServletRequest httpServletRequest) {
        if (Validator.isNotNull((String)_SESSION_COOKIE_DOMAIN)) {
            return _SESSION_COOKIE_DOMAIN;
        }
        if (_SESSION_COOKIE_USE_FULL_HOSTNAME) {
            return "";
        }
        return this.getDomain(httpServletRequest.getServerName());
    }

    public String getDomain(String host) {
        if (host == null) {
            return null;
        }
        if (Validator.isIPAddress((String)host)) {
            return host;
        }
        int x = host.lastIndexOf(46);
        if (x <= 0) {
            return null;
        }
        int y = host.lastIndexOf(46, x - 1);
        if (y <= 0) {
            return "." + host;
        }
        int z = host.lastIndexOf(46, y - 1);
        String domain = null;
        domain = z <= 0 ? host.substring(y) : host.substring(z);
        return domain;
    }

    public boolean hasConsentType(int consentType, HttpServletRequest httpServletRequest) {
        if (consentType == 2) {
            return true;
        }
        String consentCookieName = "";
        if (consentType == 1) {
            consentCookieName = "CONSENT_TYPE_FUNCTIONAL";
        } else if (consentType == 3) {
            consentCookieName = "CONSENT_TYPE_PERFORMANCE";
        } else if (consentType == 4) {
            consentCookieName = "CONSENT_TYPE_PERSONALIZATION";
        }
        String consentCookieValue = this.getCookieValue(consentCookieName, httpServletRequest);
        if (Validator.isNotNull((String)consentCookieValue)) {
            return GetterUtil.getBoolean((String)consentCookieValue);
        }
        CookiesPreferenceHandlingConfiguration cookiesPreferenceHandlingConfiguration = this._getCookiesPreferenceHandlingConfiguration(httpServletRequest);
        return !cookiesPreferenceHandlingConfiguration.explicitConsentMode();
    }

    public boolean hasSessionId(HttpServletRequest httpServletRequest) {
        String cookieValue = this.getCookieValue("JSESSIONID", httpServletRequest, false);
        return cookieValue != null;
    }

    public boolean isEncodedCookie(String cookieName) {
        return cookieName.equals("ID") || cookieName.equals("LOGIN") || cookieName.equals("PASSWORD") || cookieName.equals("USER_UUID");
    }

    public void validateSupportCookie(HttpServletRequest httpServletRequest) throws UnsupportedCookieException {
        if (_SESSION_ENABLE_PERSISTENT_COOKIES && _SESSION_TEST_COOKIE_SUPPORT && Validator.isNull((String)this.getCookieValue("COOKIE_SUPPORT", httpServletRequest, false))) {
            throw new UnsupportedCookieException();
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        for (String name : this._getProperty(properties, "cookies.functional")) {
            _internalCookies.put(name, 1);
        }
        for (String name : this._getProperty(properties, "cookies.necessary")) {
            _internalCookies.put(name, 2);
        }
        for (String name : this._getProperty(properties, "cookies.performance")) {
            _internalCookies.put(name, 3);
        }
        for (String name : this._getProperty(properties, "cookies.personalization")) {
            _internalCookies.put(name, 4);
        }
    }

    private boolean _deleteCookieConsentCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean hasConsentTypeFunctionalCookie = Validator.isNotNull((String)this.getCookieValue("CONSENT_TYPE_FUNCTIONAL", httpServletRequest));
        boolean hasConsentTypePerformanceCookie = Validator.isNotNull((String)this.getCookieValue("CONSENT_TYPE_PERFORMANCE", httpServletRequest));
        boolean hasConsentTypePersonalizationCookie = Validator.isNotNull((String)this.getCookieValue("CONSENT_TYPE_PERSONALIZATION", httpServletRequest));
        boolean hasUserConsentConfiguredCookie = Validator.isNotNull((String)this.getCookieValue("USER_CONSENT_CONFIGURED", httpServletRequest));
        if (hasConsentTypeFunctionalCookie || hasConsentTypePerformanceCookie || hasConsentTypePersonalizationCookie || hasUserConsentConfiguredCookie) {
            return this.deleteCookies(this.getDomain(httpServletRequest), httpServletRequest, httpServletResponse, "CONSENT_TYPE_FUNCTIONAL", "CONSENT_TYPE_PERFORMANCE", "CONSENT_TYPE_PERSONALIZATION", "USER_CONSENT_CONFIGURED");
        }
        return false;
    }

    private Map<String, Cookie> _getCookiesMap(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Cookie> cookiesMap = (HashMap<String, Cookie>)httpServletRequest.getAttribute(CookiesManagerImpl.class.getName());
        if (cookiesMap != null) {
            return cookiesMap;
        }
        Cookie[] cookies = httpServletRequest.getCookies();
        if (cookies == null) {
            cookiesMap = new HashMap<String, Cookie>();
        } else {
            cookiesMap = new HashMap(cookies.length * 4 / 3);
            for (Cookie cookie : cookies) {
                String cookieName = GetterUtil.getString((String)cookie.getName());
                cookieName = StringUtil.toUpperCase((String)cookieName);
                cookiesMap.put(cookieName, cookie);
            }
        }
        httpServletRequest.setAttribute(CookiesManagerImpl.class.getName(), cookiesMap);
        return cookiesMap;
    }

    private CookiesPreferenceHandlingConfiguration _getCookiesPreferenceHandlingConfiguration(HttpServletRequest httpServletRequest) {
        try {
            if (httpServletRequest != null) {
                long groupId = this._portal.getScopeGroupId(httpServletRequest);
                if (groupId > 0L) {
                    return (CookiesPreferenceHandlingConfiguration)this._configurationProvider.getGroupConfiguration(CookiesPreferenceHandlingConfiguration.class, groupId);
                }
                return (CookiesPreferenceHandlingConfiguration)this._configurationProvider.getCompanyConfiguration(CookiesPreferenceHandlingConfiguration.class, this._portal.getCompanyId(httpServletRequest));
            }
            return (CookiesPreferenceHandlingConfiguration)this._configurationProvider.getSystemConfiguration(CookiesPreferenceHandlingConfiguration.class);
        }
        catch (PortalException portalException) {
            return (CookiesPreferenceHandlingConfiguration)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    private String _getCookieValue(String cookieName, HttpServletRequest httpServletRequest, boolean toUpperCase) {
        Cookie cookie;
        Map<String, Cookie> cookiesMap = this._getCookiesMap(httpServletRequest);
        if (toUpperCase) {
            cookieName = StringUtil.toUpperCase((String)cookieName);
        }
        if ((cookie = cookiesMap.get(cookieName)) == null) {
            return null;
        }
        return cookie.getValue();
    }

    private String[] _getProperty(Map<String, Object> properties, String propertyName) {
        String[] propertyValues = GetterUtil.getStringValues((Object)properties.get(propertyName));
        if (propertyValues != null && propertyValues.length > 0) {
            return propertyValues;
        }
        String propertyValue = GetterUtil.getString((Object)properties.get(propertyName));
        if (Validator.isNotNull((String)propertyValue)) {
            return new String[]{propertyValue};
        }
        return new String[0];
    }
}

