/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.cookies.internal.configuration.provider;

import com.liferay.cookies.configuration.CookiesConfigurationProvider;
import com.liferay.cookies.configuration.CookiesPreferenceHandlingConfiguration;
import com.liferay.cookies.configuration.banner.CookiesBannerConfiguration;
import com.liferay.cookies.configuration.consent.CookiesConsentConfiguration;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CookiesConfigurationProvider.class})
public class CookiesConfigurationProviderImpl
implements CookiesConfigurationProvider {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;

    public CookiesBannerConfiguration getCookiesBannerConfiguration(ThemeDisplay themeDisplay) throws Exception {
        return this._getCookiesConfiguration(CookiesBannerConfiguration.class, themeDisplay);
    }

    public CookiesConsentConfiguration getCookiesConsentConfiguration(ThemeDisplay themeDisplay) throws Exception {
        return this._getCookiesConfiguration(CookiesConsentConfiguration.class, themeDisplay);
    }

    public CookiesPreferenceHandlingConfiguration getCookiesPreferenceHandlingConfiguration(ThemeDisplay themeDisplay) throws Exception {
        return this._getCookiesConfiguration(CookiesPreferenceHandlingConfiguration.class, themeDisplay);
    }

    private <T> T _getCookiesConfiguration(Class<T> clazz, ThemeDisplay themeDisplay) throws Exception {
        LayoutSet layoutSet = this._layoutSetLocalService.fetchLayoutSet(themeDisplay.getServerName());
        if (layoutSet != null) {
            Group group = layoutSet.getGroup();
            return (T)this._configurationProvider.getGroupConfiguration(clazz, group.getGroupId());
        }
        return (T)this._configurationProvider.getCompanyConfiguration(clazz, themeDisplay.getCompanyId());
    }
}

