/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.cookies.internal.events;

import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Component(property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class CookiesPreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(CookiesPreAction.class);

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            this._run(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private Map<String, String> _getCookieValues(Cookie[] cookies) {
        HashMap<String, String> cookieValues = new HashMap<String, String>();
        if (cookies == null) {
            return cookieValues;
        }
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            if (!cookieName.equals("USER_CONSENT_CONFIGURED") && !cookieName.startsWith("CONSENT_TYPE_")) continue;
            cookieValues.put(cookieName, cookie.getValue());
        }
        return cookieValues;
    }

    private void _run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Map<String, String> cookieValues = this._getCookieValues(httpServletRequest.getCookies());
        boolean functionalConsent = Validator.isNotNull((String)cookieValues.get("CONSENT_TYPE_FUNCTIONAL"));
        boolean performanceConsent = Validator.isNotNull((String)cookieValues.get("CONSENT_TYPE_PERFORMANCE"));
        boolean personalizationConsent = Validator.isNotNull((String)cookieValues.get("CONSENT_TYPE_PERSONALIZATION"));
        boolean optionalConsent = false;
        if (performanceConsent && functionalConsent && personalizationConsent) {
            optionalConsent = true;
        }
        boolean userConsent = Validator.isNotNull((String)cookieValues.get("USER_CONSENT_CONFIGURED"));
        if (!optionalConsent && userConsent) {
            CookiesManagerUtil.deleteCookies((String)CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"USER_CONSENT_CONFIGURED"});
        }
    }
}

