/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.data.cleanup.internal.upgrade.util.LayoutTypeSettingsUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public abstract class BaseUpgradeProcess
extends UpgradeProcess {
    protected void removePortletData(String[] bundleSymbolicNames, String[] oldPortletIds, String[] portletIds) throws Exception {
        if (ArrayUtil.getLength((Object[])oldPortletIds) > 0) {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select portletId from Portlet where portletId = ?");){
                preparedStatement.setString(1, oldPortletIds[0]);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        portletIds = oldPortletIds;
                    }
                }
            }
        }
        LayoutTypeSettingsUtil.removePortletIds(this.connection, portletIds);
        this._deleteFromPortlet(portletIds);
        this._deleteFromPortletPreferences(portletIds);
        this._deleteFromRelease(bundleSymbolicNames);
        this._deleteFromResourceAction(portletIds);
        this._deleteFromResourcePermission(portletIds);
    }

    protected void removeServiceData(String buildNamespace, String[] bundleSymbolicNames, String[] classNames, String[] tableNames) throws Exception {
        this._deleteFromClassName(classNames);
        this._deleteFromRelease(bundleSymbolicNames);
        this._deleteFromResourceAction(classNames);
        this._deleteFromResourcePermission(classNames);
        this._deleteFromServiceComponent(buildNamespace);
        this._dropTables(tableNames);
    }

    private void _deleteFrom(String tableName, String columnName, String ... columnValues) throws Exception {
        if (columnValues == null) {
            return;
        }
        for (String columnValue : columnValues) {
            this.runSQL(StringBundler.concat((String[])new String[]{"delete from ", tableName, " where ", columnName, " = '", columnValue, "'"}));
        }
    }

    private void _deleteFromClassName(String[] classNames) throws Exception {
        this._deleteFrom("ClassName_", "value", classNames);
    }

    private void _deleteFromPortlet(String[] portletIds) throws Exception {
        this._deleteFrom("Portlet", "portletId", portletIds);
    }

    private void _deleteFromPortletPreferences(String[] portletIds) throws Exception {
        if (portletIds == null) {
            return;
        }
        for (String portletId : portletIds) {
            this.runSQL(StringBundler.concat((String[])new String[]{"delete from PortletPreferences where portletId like '", portletId, "%'"}));
        }
    }

    private void _deleteFromRelease(String[] servletContextNames) throws Exception {
        this._deleteFrom("Release_", "servletContextName", servletContextNames);
    }

    private void _deleteFromResourceAction(String[] names) throws Exception {
        this._deleteFrom("ResourceAction", "name", names);
    }

    private void _deleteFromResourcePermission(String[] names) throws Exception {
        this._deleteFrom("ResourcePermission", "name", names);
    }

    private void _deleteFromServiceComponent(String buildNamespace) throws Exception {
        this._deleteFrom("ServiceComponent", "buildNamespace", buildNamespace);
    }

    private void _dropTables(String[] tableNames) throws Exception {
        if (tableNames == null) {
            return;
        }
        for (String tableName : tableNames) {
            if (!this.hasTable(tableName)) continue;
            this.runSQL("drop table " + tableName);
        }
    }
}

